/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllowCustomRoutingTrafficRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String endpointGroupArn;
    private String endpointId;
    private List<String> destinationAddresses;
    private List<Integer> destinationPorts;
    private Boolean allowAllTrafficToEndpoint;

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public AllowCustomRoutingTrafficRequest withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public AllowCustomRoutingTrafficRequest withEndpointId(String endpointId) {
        this.setEndpointId(endpointId);
        return this;
    }

    public List<String> getDestinationAddresses() {
        return this.destinationAddresses;
    }

    public void setDestinationAddresses(Collection<String> destinationAddresses) {
        if (destinationAddresses == null) {
            this.destinationAddresses = null;
            return;
        }
        this.destinationAddresses = new ArrayList<String>(destinationAddresses);
    }

    public AllowCustomRoutingTrafficRequest withDestinationAddresses(String ... destinationAddresses) {
        if (this.destinationAddresses == null) {
            this.setDestinationAddresses(new ArrayList<String>(destinationAddresses.length));
        }
        for (String ele : destinationAddresses) {
            this.destinationAddresses.add(ele);
        }
        return this;
    }

    public AllowCustomRoutingTrafficRequest withDestinationAddresses(Collection<String> destinationAddresses) {
        this.setDestinationAddresses(destinationAddresses);
        return this;
    }

    public List<Integer> getDestinationPorts() {
        return this.destinationPorts;
    }

    public void setDestinationPorts(Collection<Integer> destinationPorts) {
        if (destinationPorts == null) {
            this.destinationPorts = null;
            return;
        }
        this.destinationPorts = new ArrayList<Integer>(destinationPorts);
    }

    public AllowCustomRoutingTrafficRequest withDestinationPorts(Integer ... destinationPorts) {
        if (this.destinationPorts == null) {
            this.setDestinationPorts(new ArrayList<Integer>(destinationPorts.length));
        }
        for (Integer ele : destinationPorts) {
            this.destinationPorts.add(ele);
        }
        return this;
    }

    public AllowCustomRoutingTrafficRequest withDestinationPorts(Collection<Integer> destinationPorts) {
        this.setDestinationPorts(destinationPorts);
        return this;
    }

    public void setAllowAllTrafficToEndpoint(Boolean allowAllTrafficToEndpoint) {
        this.allowAllTrafficToEndpoint = allowAllTrafficToEndpoint;
    }

    public Boolean getAllowAllTrafficToEndpoint() {
        return this.allowAllTrafficToEndpoint;
    }

    public AllowCustomRoutingTrafficRequest withAllowAllTrafficToEndpoint(Boolean allowAllTrafficToEndpoint) {
        this.setAllowAllTrafficToEndpoint(allowAllTrafficToEndpoint);
        return this;
    }

    public Boolean isAllowAllTrafficToEndpoint() {
        return this.allowAllTrafficToEndpoint;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn()).append(",");
        }
        if (this.getEndpointId() != null) {
            sb.append("EndpointId: ").append(this.getEndpointId()).append(",");
        }
        if (this.getDestinationAddresses() != null) {
            sb.append("DestinationAddresses: ").append(this.getDestinationAddresses()).append(",");
        }
        if (this.getDestinationPorts() != null) {
            sb.append("DestinationPorts: ").append(this.getDestinationPorts()).append(",");
        }
        if (this.getAllowAllTrafficToEndpoint() != null) {
            sb.append("AllowAllTrafficToEndpoint: ").append(this.getAllowAllTrafficToEndpoint());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowCustomRoutingTrafficRequest)) {
            return false;
        }
        AllowCustomRoutingTrafficRequest other = (AllowCustomRoutingTrafficRequest)obj;
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        if (other.getEndpointGroupArn() != null && !other.getEndpointGroupArn().equals(this.getEndpointGroupArn())) {
            return false;
        }
        if (other.getEndpointId() == null ^ this.getEndpointId() == null) {
            return false;
        }
        if (other.getEndpointId() != null && !other.getEndpointId().equals(this.getEndpointId())) {
            return false;
        }
        if (other.getDestinationAddresses() == null ^ this.getDestinationAddresses() == null) {
            return false;
        }
        if (other.getDestinationAddresses() != null && !other.getDestinationAddresses().equals(this.getDestinationAddresses())) {
            return false;
        }
        if (other.getDestinationPorts() == null ^ this.getDestinationPorts() == null) {
            return false;
        }
        if (other.getDestinationPorts() != null && !other.getDestinationPorts().equals(this.getDestinationPorts())) {
            return false;
        }
        if (other.getAllowAllTrafficToEndpoint() == null ^ this.getAllowAllTrafficToEndpoint() == null) {
            return false;
        }
        return other.getAllowAllTrafficToEndpoint() == null || other.getAllowAllTrafficToEndpoint().equals(this.getAllowAllTrafficToEndpoint());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointId() == null ? 0 : this.getEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationAddresses() == null ? 0 : this.getDestinationAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPorts() == null ? 0 : this.getDestinationPorts().hashCode());
        hashCode = 31 * hashCode + (this.getAllowAllTrafficToEndpoint() == null ? 0 : this.getAllowAllTrafficToEndpoint().hashCode());
        return hashCode;
    }

    public AllowCustomRoutingTrafficRequest clone() {
        return (AllowCustomRoutingTrafficRequest)super.clone();
    }
}

