/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.globalaccelerator.model.EndpointConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddEndpointsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<EndpointConfiguration> endpointConfigurations;
    private String endpointGroupArn;

    public List<EndpointConfiguration> getEndpointConfigurations() {
        return this.endpointConfigurations;
    }

    public void setEndpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
        if (endpointConfigurations == null) {
            this.endpointConfigurations = null;
            return;
        }
        this.endpointConfigurations = new ArrayList<EndpointConfiguration>(endpointConfigurations);
    }

    public AddEndpointsRequest withEndpointConfigurations(EndpointConfiguration ... endpointConfigurations) {
        if (this.endpointConfigurations == null) {
            this.setEndpointConfigurations(new ArrayList<EndpointConfiguration>(endpointConfigurations.length));
        }
        for (EndpointConfiguration ele : endpointConfigurations) {
            this.endpointConfigurations.add(ele);
        }
        return this;
    }

    public AddEndpointsRequest withEndpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
        this.setEndpointConfigurations(endpointConfigurations);
        return this;
    }

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public AddEndpointsRequest withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointConfigurations() != null) {
            sb.append("EndpointConfigurations: ").append(this.getEndpointConfigurations()).append(",");
        }
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddEndpointsRequest)) {
            return false;
        }
        AddEndpointsRequest other = (AddEndpointsRequest)obj;
        if (other.getEndpointConfigurations() == null ^ this.getEndpointConfigurations() == null) {
            return false;
        }
        if (other.getEndpointConfigurations() != null && !other.getEndpointConfigurations().equals(this.getEndpointConfigurations())) {
            return false;
        }
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        return other.getEndpointGroupArn() == null || other.getEndpointGroupArn().equals(this.getEndpointGroupArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointConfigurations() == null ? 0 : this.getEndpointConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        return hashCode;
    }

    public AddEndpointsRequest clone() {
        return (AddEndpointsRequest)super.clone();
    }
}

