/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.UploadListElement;

public class UploadListElementJsonMarshaller {
    private static UploadListElementJsonMarshaller instance;

    public void marshall(UploadListElement uploadListElement, StructuredJsonGenerator jsonGenerator) {
        if (uploadListElement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (uploadListElement.getMultipartUploadId() != null) {
                jsonGenerator.writeFieldName("MultipartUploadId").writeValue(uploadListElement.getMultipartUploadId());
            }
            if (uploadListElement.getVaultARN() != null) {
                jsonGenerator.writeFieldName("VaultARN").writeValue(uploadListElement.getVaultARN());
            }
            if (uploadListElement.getArchiveDescription() != null) {
                jsonGenerator.writeFieldName("ArchiveDescription").writeValue(uploadListElement.getArchiveDescription());
            }
            if (uploadListElement.getPartSizeInBytes() != null) {
                jsonGenerator.writeFieldName("PartSizeInBytes").writeValue(uploadListElement.getPartSizeInBytes().longValue());
            }
            if (uploadListElement.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(uploadListElement.getCreationDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UploadListElementJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UploadListElementJsonMarshaller();
        }
        return instance;
    }
}

