/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InventoryRetrievalJobInput;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class InitiateJobRequestMarshaller
implements Marshaller<Request<InitiateJobRequest>, InitiateJobRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<InitiateJobRequest> marshall(InitiateJobRequest initiateJobRequest) {
        Object name;
        if (initiateJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)initiateJobRequest, "AmazonGlacier");
        String target = "Glacier.InitiateJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("accountId")) {
            String string;
            name = DYNAMIC_QUERY_PARAMS.get("accountId");
            String string2 = string = initiateJobRequest.getAccountId() == null ? null : StringUtils.fromString((String)initiateJobRequest.getAccountId());
            if (string != null && !string.isEmpty()) {
                request.addParameter((String)name, string);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{accountId}", initiateJobRequest.getAccountId() == null ? "" : StringUtils.fromString((String)initiateJobRequest.getAccountId()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("vaultName")) {
            String string;
            name = DYNAMIC_QUERY_PARAMS.get("vaultName");
            String string3 = string = initiateJobRequest.getVaultName() == null ? null : StringUtils.fromString((String)initiateJobRequest.getVaultName());
            if (string != null && !string.isEmpty()) {
                request.addParameter((String)name, string);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{vaultName}", initiateJobRequest.getVaultName() == null ? "" : StringUtils.fromString((String)initiateJobRequest.getVaultName()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jSONWriter = new JSONWriter((Writer)stringWriter);
            JobParameters jobParameters = initiateJobRequest.getJobParameters();
            if (jobParameters != null) {
                InventoryRetrievalJobInput inventoryRetrievalParameters;
                jSONWriter.object();
                if (jobParameters.getFormat() != null) {
                    jSONWriter.key("Format").value((Object)jobParameters.getFormat());
                }
                if (jobParameters.getType() != null) {
                    jSONWriter.key("Type").value((Object)jobParameters.getType());
                }
                if (jobParameters.getArchiveId() != null) {
                    jSONWriter.key("ArchiveId").value((Object)jobParameters.getArchiveId());
                }
                if (jobParameters.getDescription() != null) {
                    jSONWriter.key("Description").value((Object)jobParameters.getDescription());
                }
                if (jobParameters.getSNSTopic() != null) {
                    jSONWriter.key("SNSTopic").value((Object)jobParameters.getSNSTopic());
                }
                if (jobParameters.getRetrievalByteRange() != null) {
                    jSONWriter.key("RetrievalByteRange").value((Object)jobParameters.getRetrievalByteRange());
                }
                if ((inventoryRetrievalParameters = jobParameters.getInventoryRetrievalParameters()) != null) {
                    jSONWriter.key("InventoryRetrievalParameters");
                    jSONWriter.object();
                    if (inventoryRetrievalParameters.getStartDate() != null) {
                        jSONWriter.key("StartDate").value((Object)inventoryRetrievalParameters.getStartDate());
                    }
                    if (inventoryRetrievalParameters.getEndDate() != null) {
                        jSONWriter.key("EndDate").value((Object)inventoryRetrievalParameters.getEndDate());
                    }
                    if (inventoryRetrievalParameters.getLimit() != null) {
                        jSONWriter.key("Limit").value((Object)inventoryRetrievalParameters.getLimit());
                    }
                    if (inventoryRetrievalParameters.getMarker() != null) {
                        jSONWriter.key("Marker").value((Object)inventoryRetrievalParameters.getMarker());
                    }
                    jSONWriter.endObject();
                }
                jSONWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    static {
        String path = "/{accountId}/vaults/{vaultName}/jobs";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

