/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamesparks.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.gamesparks.model.SnapshotSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSnapshotsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SnapshotSummary> snapshots;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSnapshotsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SnapshotSummary> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(Collection<SnapshotSummary> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        this.snapshots = new ArrayList<SnapshotSummary>(snapshots);
    }

    public ListSnapshotsResult withSnapshots(SnapshotSummary ... snapshots) {
        if (this.snapshots == null) {
            this.setSnapshots(new ArrayList<SnapshotSummary>(snapshots.length));
        }
        for (SnapshotSummary ele : snapshots) {
            this.snapshots.add(ele);
        }
        return this;
    }

    public ListSnapshotsResult withSnapshots(Collection<SnapshotSummary> snapshots) {
        this.setSnapshots(snapshots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: ").append(this.getSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotsResult)) {
            return false;
        }
        ListSnapshotsResult other = (ListSnapshotsResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        return other.getSnapshots() == null || other.getSnapshots().equals(this.getSnapshots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        return hashCode;
    }

    public ListSnapshotsResult clone() {
        try {
            return (ListSnapshotsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

