/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.AutoExportPolicy;
import com.amazonaws.services.fsx.model.NfsVersion;
import com.amazonaws.services.fsx.model.transform.NFSDataRepositoryConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NFSDataRepositoryConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String version;
    private List<String> dnsIps;
    private AutoExportPolicy autoExportPolicy;

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public NFSDataRepositoryConfiguration withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public NFSDataRepositoryConfiguration withVersion(NfsVersion version) {
        this.version = version.toString();
        return this;
    }

    public List<String> getDnsIps() {
        return this.dnsIps;
    }

    public void setDnsIps(Collection<String> dnsIps) {
        if (dnsIps == null) {
            this.dnsIps = null;
            return;
        }
        this.dnsIps = new ArrayList<String>(dnsIps);
    }

    public NFSDataRepositoryConfiguration withDnsIps(String ... dnsIps) {
        if (this.dnsIps == null) {
            this.setDnsIps(new ArrayList<String>(dnsIps.length));
        }
        for (String ele : dnsIps) {
            this.dnsIps.add(ele);
        }
        return this;
    }

    public NFSDataRepositoryConfiguration withDnsIps(Collection<String> dnsIps) {
        this.setDnsIps(dnsIps);
        return this;
    }

    public void setAutoExportPolicy(AutoExportPolicy autoExportPolicy) {
        this.autoExportPolicy = autoExportPolicy;
    }

    public AutoExportPolicy getAutoExportPolicy() {
        return this.autoExportPolicy;
    }

    public NFSDataRepositoryConfiguration withAutoExportPolicy(AutoExportPolicy autoExportPolicy) {
        this.setAutoExportPolicy(autoExportPolicy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getDnsIps() != null) {
            sb.append("DnsIps: ").append(this.getDnsIps()).append(",");
        }
        if (this.getAutoExportPolicy() != null) {
            sb.append("AutoExportPolicy: ").append(this.getAutoExportPolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NFSDataRepositoryConfiguration)) {
            return false;
        }
        NFSDataRepositoryConfiguration other = (NFSDataRepositoryConfiguration)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getDnsIps() == null ^ this.getDnsIps() == null) {
            return false;
        }
        if (other.getDnsIps() != null && !other.getDnsIps().equals(this.getDnsIps())) {
            return false;
        }
        if (other.getAutoExportPolicy() == null ^ this.getAutoExportPolicy() == null) {
            return false;
        }
        return other.getAutoExportPolicy() == null || other.getAutoExportPolicy().equals(this.getAutoExportPolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDnsIps() == null ? 0 : this.getDnsIps().hashCode());
        hashCode = 31 * hashCode + (this.getAutoExportPolicy() == null ? 0 : this.getAutoExportPolicy().hashCode());
        return hashCode;
    }

    public NFSDataRepositoryConfiguration clone() {
        try {
            return (NFSDataRepositoryConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NFSDataRepositoryConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

