/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.fsx.AmazonFSxAsync;
import com.amazonaws.services.fsx.AmazonFSxAsyncClientBuilder;
import com.amazonaws.services.fsx.AmazonFSxClient;
import com.amazonaws.services.fsx.model.AssociateFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.AssociateFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.CancelDataRepositoryTaskRequest;
import com.amazonaws.services.fsx.model.CancelDataRepositoryTaskResult;
import com.amazonaws.services.fsx.model.CopyBackupRequest;
import com.amazonaws.services.fsx.model.CopyBackupResult;
import com.amazonaws.services.fsx.model.CreateBackupRequest;
import com.amazonaws.services.fsx.model.CreateBackupResult;
import com.amazonaws.services.fsx.model.CreateDataRepositoryAssociationRequest;
import com.amazonaws.services.fsx.model.CreateDataRepositoryAssociationResult;
import com.amazonaws.services.fsx.model.CreateDataRepositoryTaskRequest;
import com.amazonaws.services.fsx.model.CreateDataRepositoryTaskResult;
import com.amazonaws.services.fsx.model.CreateFileCacheRequest;
import com.amazonaws.services.fsx.model.CreateFileCacheResult;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupResult;
import com.amazonaws.services.fsx.model.CreateFileSystemRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemResult;
import com.amazonaws.services.fsx.model.CreateSnapshotRequest;
import com.amazonaws.services.fsx.model.CreateSnapshotResult;
import com.amazonaws.services.fsx.model.CreateStorageVirtualMachineRequest;
import com.amazonaws.services.fsx.model.CreateStorageVirtualMachineResult;
import com.amazonaws.services.fsx.model.CreateVolumeFromBackupRequest;
import com.amazonaws.services.fsx.model.CreateVolumeFromBackupResult;
import com.amazonaws.services.fsx.model.CreateVolumeRequest;
import com.amazonaws.services.fsx.model.CreateVolumeResult;
import com.amazonaws.services.fsx.model.DeleteBackupRequest;
import com.amazonaws.services.fsx.model.DeleteBackupResult;
import com.amazonaws.services.fsx.model.DeleteDataRepositoryAssociationRequest;
import com.amazonaws.services.fsx.model.DeleteDataRepositoryAssociationResult;
import com.amazonaws.services.fsx.model.DeleteFileCacheRequest;
import com.amazonaws.services.fsx.model.DeleteFileCacheResult;
import com.amazonaws.services.fsx.model.DeleteFileSystemRequest;
import com.amazonaws.services.fsx.model.DeleteFileSystemResult;
import com.amazonaws.services.fsx.model.DeleteSnapshotRequest;
import com.amazonaws.services.fsx.model.DeleteSnapshotResult;
import com.amazonaws.services.fsx.model.DeleteStorageVirtualMachineRequest;
import com.amazonaws.services.fsx.model.DeleteStorageVirtualMachineResult;
import com.amazonaws.services.fsx.model.DeleteVolumeRequest;
import com.amazonaws.services.fsx.model.DeleteVolumeResult;
import com.amazonaws.services.fsx.model.DescribeBackupsRequest;
import com.amazonaws.services.fsx.model.DescribeBackupsResult;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryAssociationsRequest;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryAssociationsResult;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryTasksRequest;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryTasksResult;
import com.amazonaws.services.fsx.model.DescribeFileCachesRequest;
import com.amazonaws.services.fsx.model.DescribeFileCachesResult;
import com.amazonaws.services.fsx.model.DescribeFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.DescribeFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.DescribeFileSystemsRequest;
import com.amazonaws.services.fsx.model.DescribeFileSystemsResult;
import com.amazonaws.services.fsx.model.DescribeSnapshotsRequest;
import com.amazonaws.services.fsx.model.DescribeSnapshotsResult;
import com.amazonaws.services.fsx.model.DescribeStorageVirtualMachinesRequest;
import com.amazonaws.services.fsx.model.DescribeStorageVirtualMachinesResult;
import com.amazonaws.services.fsx.model.DescribeVolumesRequest;
import com.amazonaws.services.fsx.model.DescribeVolumesResult;
import com.amazonaws.services.fsx.model.DisassociateFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.DisassociateFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.ListTagsForResourceRequest;
import com.amazonaws.services.fsx.model.ListTagsForResourceResult;
import com.amazonaws.services.fsx.model.ReleaseFileSystemNfsV3LocksRequest;
import com.amazonaws.services.fsx.model.ReleaseFileSystemNfsV3LocksResult;
import com.amazonaws.services.fsx.model.RestoreVolumeFromSnapshotRequest;
import com.amazonaws.services.fsx.model.RestoreVolumeFromSnapshotResult;
import com.amazonaws.services.fsx.model.StartMisconfiguredStateRecoveryRequest;
import com.amazonaws.services.fsx.model.StartMisconfiguredStateRecoveryResult;
import com.amazonaws.services.fsx.model.TagResourceRequest;
import com.amazonaws.services.fsx.model.TagResourceResult;
import com.amazonaws.services.fsx.model.UntagResourceRequest;
import com.amazonaws.services.fsx.model.UntagResourceResult;
import com.amazonaws.services.fsx.model.UpdateDataRepositoryAssociationRequest;
import com.amazonaws.services.fsx.model.UpdateDataRepositoryAssociationResult;
import com.amazonaws.services.fsx.model.UpdateFileCacheRequest;
import com.amazonaws.services.fsx.model.UpdateFileCacheResult;
import com.amazonaws.services.fsx.model.UpdateFileSystemRequest;
import com.amazonaws.services.fsx.model.UpdateFileSystemResult;
import com.amazonaws.services.fsx.model.UpdateSnapshotRequest;
import com.amazonaws.services.fsx.model.UpdateSnapshotResult;
import com.amazonaws.services.fsx.model.UpdateStorageVirtualMachineRequest;
import com.amazonaws.services.fsx.model.UpdateStorageVirtualMachineResult;
import com.amazonaws.services.fsx.model.UpdateVolumeRequest;
import com.amazonaws.services.fsx.model.UpdateVolumeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonFSxAsyncClient
extends AmazonFSxClient
implements AmazonFSxAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonFSxAsyncClientBuilder asyncBuilder() {
        return AmazonFSxAsyncClientBuilder.standard();
    }

    AmazonFSxAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonFSxAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateFileSystemAliasesResult> associateFileSystemAliasesAsync(AssociateFileSystemAliasesRequest request) {
        return this.associateFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<AssociateFileSystemAliasesResult> associateFileSystemAliasesAsync(AssociateFileSystemAliasesRequest request, final AsyncHandler<AssociateFileSystemAliasesRequest, AssociateFileSystemAliasesResult> asyncHandler) {
        final AssociateFileSystemAliasesRequest finalRequest = (AssociateFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateFileSystemAliasesResult>(){

            @Override
            public AssociateFileSystemAliasesResult call() throws Exception {
                AssociateFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeAssociateFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelDataRepositoryTaskResult> cancelDataRepositoryTaskAsync(CancelDataRepositoryTaskRequest request) {
        return this.cancelDataRepositoryTaskAsync(request, null);
    }

    @Override
    public Future<CancelDataRepositoryTaskResult> cancelDataRepositoryTaskAsync(CancelDataRepositoryTaskRequest request, final AsyncHandler<CancelDataRepositoryTaskRequest, CancelDataRepositoryTaskResult> asyncHandler) {
        final CancelDataRepositoryTaskRequest finalRequest = (CancelDataRepositoryTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelDataRepositoryTaskResult>(){

            @Override
            public CancelDataRepositoryTaskResult call() throws Exception {
                CancelDataRepositoryTaskResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCancelDataRepositoryTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CopyBackupResult> copyBackupAsync(CopyBackupRequest request) {
        return this.copyBackupAsync(request, null);
    }

    @Override
    public Future<CopyBackupResult> copyBackupAsync(CopyBackupRequest request, final AsyncHandler<CopyBackupRequest, CopyBackupResult> asyncHandler) {
        final CopyBackupRequest finalRequest = (CopyBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CopyBackupResult>(){

            @Override
            public CopyBackupResult call() throws Exception {
                CopyBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCopyBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupAsync(request, null);
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request, final AsyncHandler<CreateBackupRequest, CreateBackupResult> asyncHandler) {
        final CreateBackupRequest finalRequest = (CreateBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                CreateBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataRepositoryAssociationResult> createDataRepositoryAssociationAsync(CreateDataRepositoryAssociationRequest request) {
        return this.createDataRepositoryAssociationAsync(request, null);
    }

    @Override
    public Future<CreateDataRepositoryAssociationResult> createDataRepositoryAssociationAsync(CreateDataRepositoryAssociationRequest request, final AsyncHandler<CreateDataRepositoryAssociationRequest, CreateDataRepositoryAssociationResult> asyncHandler) {
        final CreateDataRepositoryAssociationRequest finalRequest = (CreateDataRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataRepositoryAssociationResult>(){

            @Override
            public CreateDataRepositoryAssociationResult call() throws Exception {
                CreateDataRepositoryAssociationResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateDataRepositoryAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataRepositoryTaskResult> createDataRepositoryTaskAsync(CreateDataRepositoryTaskRequest request) {
        return this.createDataRepositoryTaskAsync(request, null);
    }

    @Override
    public Future<CreateDataRepositoryTaskResult> createDataRepositoryTaskAsync(CreateDataRepositoryTaskRequest request, final AsyncHandler<CreateDataRepositoryTaskRequest, CreateDataRepositoryTaskResult> asyncHandler) {
        final CreateDataRepositoryTaskRequest finalRequest = (CreateDataRepositoryTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataRepositoryTaskResult>(){

            @Override
            public CreateDataRepositoryTaskResult call() throws Exception {
                CreateDataRepositoryTaskResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateDataRepositoryTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileCacheResult> createFileCacheAsync(CreateFileCacheRequest request) {
        return this.createFileCacheAsync(request, null);
    }

    @Override
    public Future<CreateFileCacheResult> createFileCacheAsync(CreateFileCacheRequest request, final AsyncHandler<CreateFileCacheRequest, CreateFileCacheResult> asyncHandler) {
        final CreateFileCacheRequest finalRequest = (CreateFileCacheRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileCacheResult>(){

            @Override
            public CreateFileCacheResult call() throws Exception {
                CreateFileCacheResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateFileCache(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request) {
        return this.createFileSystemAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) {
        final CreateFileSystemRequest finalRequest = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileSystemFromBackupResult> createFileSystemFromBackupAsync(CreateFileSystemFromBackupRequest request) {
        return this.createFileSystemFromBackupAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemFromBackupResult> createFileSystemFromBackupAsync(CreateFileSystemFromBackupRequest request, final AsyncHandler<CreateFileSystemFromBackupRequest, CreateFileSystemFromBackupResult> asyncHandler) {
        final CreateFileSystemFromBackupRequest finalRequest = (CreateFileSystemFromBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemFromBackupResult>(){

            @Override
            public CreateFileSystemFromBackupResult call() throws Exception {
                CreateFileSystemFromBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateFileSystemFromBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        final CreateSnapshotRequest finalRequest = (CreateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStorageVirtualMachineResult> createStorageVirtualMachineAsync(CreateStorageVirtualMachineRequest request) {
        return this.createStorageVirtualMachineAsync(request, null);
    }

    @Override
    public Future<CreateStorageVirtualMachineResult> createStorageVirtualMachineAsync(CreateStorageVirtualMachineRequest request, final AsyncHandler<CreateStorageVirtualMachineRequest, CreateStorageVirtualMachineResult> asyncHandler) {
        final CreateStorageVirtualMachineRequest finalRequest = (CreateStorageVirtualMachineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStorageVirtualMachineResult>(){

            @Override
            public CreateStorageVirtualMachineResult call() throws Exception {
                CreateStorageVirtualMachineResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateStorageVirtualMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(CreateVolumeRequest request) {
        return this.createVolumeAsync(request, null);
    }

    @Override
    public Future<CreateVolumeResult> createVolumeAsync(CreateVolumeRequest request, final AsyncHandler<CreateVolumeRequest, CreateVolumeResult> asyncHandler) {
        final CreateVolumeRequest finalRequest = (CreateVolumeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVolumeResult>(){

            @Override
            public CreateVolumeResult call() throws Exception {
                CreateVolumeResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateVolume(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVolumeFromBackupResult> createVolumeFromBackupAsync(CreateVolumeFromBackupRequest request) {
        return this.createVolumeFromBackupAsync(request, null);
    }

    @Override
    public Future<CreateVolumeFromBackupResult> createVolumeFromBackupAsync(CreateVolumeFromBackupRequest request, final AsyncHandler<CreateVolumeFromBackupRequest, CreateVolumeFromBackupResult> asyncHandler) {
        final CreateVolumeFromBackupRequest finalRequest = (CreateVolumeFromBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateVolumeFromBackupResult>(){

            @Override
            public CreateVolumeFromBackupResult call() throws Exception {
                CreateVolumeFromBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateVolumeFromBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupAsync(request, null);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) {
        final DeleteBackupRequest finalRequest = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDataRepositoryAssociationResult> deleteDataRepositoryAssociationAsync(DeleteDataRepositoryAssociationRequest request) {
        return this.deleteDataRepositoryAssociationAsync(request, null);
    }

    @Override
    public Future<DeleteDataRepositoryAssociationResult> deleteDataRepositoryAssociationAsync(DeleteDataRepositoryAssociationRequest request, final AsyncHandler<DeleteDataRepositoryAssociationRequest, DeleteDataRepositoryAssociationResult> asyncHandler) {
        final DeleteDataRepositoryAssociationRequest finalRequest = (DeleteDataRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDataRepositoryAssociationResult>(){

            @Override
            public DeleteDataRepositoryAssociationResult call() throws Exception {
                DeleteDataRepositoryAssociationResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteDataRepositoryAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileCacheResult> deleteFileCacheAsync(DeleteFileCacheRequest request) {
        return this.deleteFileCacheAsync(request, null);
    }

    @Override
    public Future<DeleteFileCacheResult> deleteFileCacheAsync(DeleteFileCacheRequest request, final AsyncHandler<DeleteFileCacheRequest, DeleteFileCacheResult> asyncHandler) {
        final DeleteFileCacheRequest finalRequest = (DeleteFileCacheRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileCacheResult>(){

            @Override
            public DeleteFileCacheResult call() throws Exception {
                DeleteFileCacheResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteFileCache(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request) {
        return this.deleteFileSystemAsync(request, null);
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request, final AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResult> asyncHandler) {
        final DeleteFileSystemRequest finalRequest = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileSystemResult>(){

            @Override
            public DeleteFileSystemResult call() throws Exception {
                DeleteFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) {
        final DeleteSnapshotRequest finalRequest = (DeleteSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                DeleteSnapshotResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStorageVirtualMachineResult> deleteStorageVirtualMachineAsync(DeleteStorageVirtualMachineRequest request) {
        return this.deleteStorageVirtualMachineAsync(request, null);
    }

    @Override
    public Future<DeleteStorageVirtualMachineResult> deleteStorageVirtualMachineAsync(DeleteStorageVirtualMachineRequest request, final AsyncHandler<DeleteStorageVirtualMachineRequest, DeleteStorageVirtualMachineResult> asyncHandler) {
        final DeleteStorageVirtualMachineRequest finalRequest = (DeleteStorageVirtualMachineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStorageVirtualMachineResult>(){

            @Override
            public DeleteStorageVirtualMachineResult call() throws Exception {
                DeleteStorageVirtualMachineResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteStorageVirtualMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVolumeResult> deleteVolumeAsync(DeleteVolumeRequest request) {
        return this.deleteVolumeAsync(request, null);
    }

    @Override
    public Future<DeleteVolumeResult> deleteVolumeAsync(DeleteVolumeRequest request, final AsyncHandler<DeleteVolumeRequest, DeleteVolumeResult> asyncHandler) {
        final DeleteVolumeRequest finalRequest = (DeleteVolumeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteVolumeResult>(){

            @Override
            public DeleteVolumeResult call() throws Exception {
                DeleteVolumeResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteVolume(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request) {
        return this.describeBackupsAsync(request, null);
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request, final AsyncHandler<DescribeBackupsRequest, DescribeBackupsResult> asyncHandler) {
        final DescribeBackupsRequest finalRequest = (DescribeBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBackupsResult>(){

            @Override
            public DescribeBackupsResult call() throws Exception {
                DescribeBackupsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataRepositoryAssociationsResult> describeDataRepositoryAssociationsAsync(DescribeDataRepositoryAssociationsRequest request) {
        return this.describeDataRepositoryAssociationsAsync(request, null);
    }

    @Override
    public Future<DescribeDataRepositoryAssociationsResult> describeDataRepositoryAssociationsAsync(DescribeDataRepositoryAssociationsRequest request, final AsyncHandler<DescribeDataRepositoryAssociationsRequest, DescribeDataRepositoryAssociationsResult> asyncHandler) {
        final DescribeDataRepositoryAssociationsRequest finalRequest = (DescribeDataRepositoryAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDataRepositoryAssociationsResult>(){

            @Override
            public DescribeDataRepositoryAssociationsResult call() throws Exception {
                DescribeDataRepositoryAssociationsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeDataRepositoryAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataRepositoryTasksResult> describeDataRepositoryTasksAsync(DescribeDataRepositoryTasksRequest request) {
        return this.describeDataRepositoryTasksAsync(request, null);
    }

    @Override
    public Future<DescribeDataRepositoryTasksResult> describeDataRepositoryTasksAsync(DescribeDataRepositoryTasksRequest request, final AsyncHandler<DescribeDataRepositoryTasksRequest, DescribeDataRepositoryTasksResult> asyncHandler) {
        final DescribeDataRepositoryTasksRequest finalRequest = (DescribeDataRepositoryTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDataRepositoryTasksResult>(){

            @Override
            public DescribeDataRepositoryTasksResult call() throws Exception {
                DescribeDataRepositoryTasksResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeDataRepositoryTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileCachesResult> describeFileCachesAsync(DescribeFileCachesRequest request) {
        return this.describeFileCachesAsync(request, null);
    }

    @Override
    public Future<DescribeFileCachesResult> describeFileCachesAsync(DescribeFileCachesRequest request, final AsyncHandler<DescribeFileCachesRequest, DescribeFileCachesResult> asyncHandler) {
        final DescribeFileCachesRequest finalRequest = (DescribeFileCachesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileCachesResult>(){

            @Override
            public DescribeFileCachesResult call() throws Exception {
                DescribeFileCachesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeFileCaches(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemAliasesResult> describeFileSystemAliasesAsync(DescribeFileSystemAliasesRequest request) {
        return this.describeFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemAliasesResult> describeFileSystemAliasesAsync(DescribeFileSystemAliasesRequest request, final AsyncHandler<DescribeFileSystemAliasesRequest, DescribeFileSystemAliasesResult> asyncHandler) {
        final DescribeFileSystemAliasesRequest finalRequest = (DescribeFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemAliasesResult>(){

            @Override
            public DescribeFileSystemAliasesResult call() throws Exception {
                DescribeFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request) {
        return this.describeFileSystemsAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        final DescribeFileSystemsRequest finalRequest = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeFileSystems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        final DescribeSnapshotsRequest finalRequest = (DescribeSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStorageVirtualMachinesResult> describeStorageVirtualMachinesAsync(DescribeStorageVirtualMachinesRequest request) {
        return this.describeStorageVirtualMachinesAsync(request, null);
    }

    @Override
    public Future<DescribeStorageVirtualMachinesResult> describeStorageVirtualMachinesAsync(DescribeStorageVirtualMachinesRequest request, final AsyncHandler<DescribeStorageVirtualMachinesRequest, DescribeStorageVirtualMachinesResult> asyncHandler) {
        final DescribeStorageVirtualMachinesRequest finalRequest = (DescribeStorageVirtualMachinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStorageVirtualMachinesResult>(){

            @Override
            public DescribeStorageVirtualMachinesResult call() throws Exception {
                DescribeStorageVirtualMachinesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeStorageVirtualMachines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(DescribeVolumesRequest request) {
        return this.describeVolumesAsync(request, null);
    }

    @Override
    public Future<DescribeVolumesResult> describeVolumesAsync(DescribeVolumesRequest request, final AsyncHandler<DescribeVolumesRequest, DescribeVolumesResult> asyncHandler) {
        final DescribeVolumesRequest finalRequest = (DescribeVolumesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeVolumesResult>(){

            @Override
            public DescribeVolumesResult call() throws Exception {
                DescribeVolumesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeVolumes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFileSystemAliasesResult> disassociateFileSystemAliasesAsync(DisassociateFileSystemAliasesRequest request) {
        return this.disassociateFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<DisassociateFileSystemAliasesResult> disassociateFileSystemAliasesAsync(DisassociateFileSystemAliasesRequest request, final AsyncHandler<DisassociateFileSystemAliasesRequest, DisassociateFileSystemAliasesResult> asyncHandler) {
        final DisassociateFileSystemAliasesRequest finalRequest = (DisassociateFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFileSystemAliasesResult>(){

            @Override
            public DisassociateFileSystemAliasesResult call() throws Exception {
                DisassociateFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDisassociateFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReleaseFileSystemNfsV3LocksResult> releaseFileSystemNfsV3LocksAsync(ReleaseFileSystemNfsV3LocksRequest request) {
        return this.releaseFileSystemNfsV3LocksAsync(request, null);
    }

    @Override
    public Future<ReleaseFileSystemNfsV3LocksResult> releaseFileSystemNfsV3LocksAsync(ReleaseFileSystemNfsV3LocksRequest request, final AsyncHandler<ReleaseFileSystemNfsV3LocksRequest, ReleaseFileSystemNfsV3LocksResult> asyncHandler) {
        final ReleaseFileSystemNfsV3LocksRequest finalRequest = (ReleaseFileSystemNfsV3LocksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReleaseFileSystemNfsV3LocksResult>(){

            @Override
            public ReleaseFileSystemNfsV3LocksResult call() throws Exception {
                ReleaseFileSystemNfsV3LocksResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeReleaseFileSystemNfsV3Locks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreVolumeFromSnapshotResult> restoreVolumeFromSnapshotAsync(RestoreVolumeFromSnapshotRequest request) {
        return this.restoreVolumeFromSnapshotAsync(request, null);
    }

    @Override
    public Future<RestoreVolumeFromSnapshotResult> restoreVolumeFromSnapshotAsync(RestoreVolumeFromSnapshotRequest request, final AsyncHandler<RestoreVolumeFromSnapshotRequest, RestoreVolumeFromSnapshotResult> asyncHandler) {
        final RestoreVolumeFromSnapshotRequest finalRequest = (RestoreVolumeFromSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreVolumeFromSnapshotResult>(){

            @Override
            public RestoreVolumeFromSnapshotResult call() throws Exception {
                RestoreVolumeFromSnapshotResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeRestoreVolumeFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMisconfiguredStateRecoveryResult> startMisconfiguredStateRecoveryAsync(StartMisconfiguredStateRecoveryRequest request) {
        return this.startMisconfiguredStateRecoveryAsync(request, null);
    }

    @Override
    public Future<StartMisconfiguredStateRecoveryResult> startMisconfiguredStateRecoveryAsync(StartMisconfiguredStateRecoveryRequest request, final AsyncHandler<StartMisconfiguredStateRecoveryRequest, StartMisconfiguredStateRecoveryResult> asyncHandler) {
        final StartMisconfiguredStateRecoveryRequest finalRequest = (StartMisconfiguredStateRecoveryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMisconfiguredStateRecoveryResult>(){

            @Override
            public StartMisconfiguredStateRecoveryResult call() throws Exception {
                StartMisconfiguredStateRecoveryResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeStartMisconfiguredStateRecovery(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDataRepositoryAssociationResult> updateDataRepositoryAssociationAsync(UpdateDataRepositoryAssociationRequest request) {
        return this.updateDataRepositoryAssociationAsync(request, null);
    }

    @Override
    public Future<UpdateDataRepositoryAssociationResult> updateDataRepositoryAssociationAsync(UpdateDataRepositoryAssociationRequest request, final AsyncHandler<UpdateDataRepositoryAssociationRequest, UpdateDataRepositoryAssociationResult> asyncHandler) {
        final UpdateDataRepositoryAssociationRequest finalRequest = (UpdateDataRepositoryAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDataRepositoryAssociationResult>(){

            @Override
            public UpdateDataRepositoryAssociationResult call() throws Exception {
                UpdateDataRepositoryAssociationResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateDataRepositoryAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFileCacheResult> updateFileCacheAsync(UpdateFileCacheRequest request) {
        return this.updateFileCacheAsync(request, null);
    }

    @Override
    public Future<UpdateFileCacheResult> updateFileCacheAsync(UpdateFileCacheRequest request, final AsyncHandler<UpdateFileCacheRequest, UpdateFileCacheResult> asyncHandler) {
        final UpdateFileCacheRequest finalRequest = (UpdateFileCacheRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFileCacheResult>(){

            @Override
            public UpdateFileCacheResult call() throws Exception {
                UpdateFileCacheResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateFileCache(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request) {
        return this.updateFileSystemAsync(request, null);
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request, final AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResult> asyncHandler) {
        final UpdateFileSystemRequest finalRequest = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFileSystemResult>(){

            @Override
            public UpdateFileSystemResult call() throws Exception {
                UpdateFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request) {
        return this.updateSnapshotAsync(request, null);
    }

    @Override
    public Future<UpdateSnapshotResult> updateSnapshotAsync(UpdateSnapshotRequest request, final AsyncHandler<UpdateSnapshotRequest, UpdateSnapshotResult> asyncHandler) {
        final UpdateSnapshotRequest finalRequest = (UpdateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSnapshotResult>(){

            @Override
            public UpdateSnapshotResult call() throws Exception {
                UpdateSnapshotResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStorageVirtualMachineResult> updateStorageVirtualMachineAsync(UpdateStorageVirtualMachineRequest request) {
        return this.updateStorageVirtualMachineAsync(request, null);
    }

    @Override
    public Future<UpdateStorageVirtualMachineResult> updateStorageVirtualMachineAsync(UpdateStorageVirtualMachineRequest request, final AsyncHandler<UpdateStorageVirtualMachineRequest, UpdateStorageVirtualMachineResult> asyncHandler) {
        final UpdateStorageVirtualMachineRequest finalRequest = (UpdateStorageVirtualMachineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStorageVirtualMachineResult>(){

            @Override
            public UpdateStorageVirtualMachineResult call() throws Exception {
                UpdateStorageVirtualMachineResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateStorageVirtualMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVolumeResult> updateVolumeAsync(UpdateVolumeRequest request) {
        return this.updateVolumeAsync(request, null);
    }

    @Override
    public Future<UpdateVolumeResult> updateVolumeAsync(UpdateVolumeRequest request, final AsyncHandler<UpdateVolumeRequest, UpdateVolumeResult> asyncHandler) {
        final UpdateVolumeRequest finalRequest = (UpdateVolumeRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateVolumeResult>(){

            @Override
            public UpdateVolumeResult call() throws Exception {
                UpdateVolumeResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateVolume(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

