/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.ATIMetricDataPoint;
import com.amazonaws.services.frauddetector.model.ATIModelPerformance;
import com.amazonaws.services.frauddetector.model.transform.ATITrainingMetricsValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ATITrainingMetricsValue
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ATIMetricDataPoint> metricDataPoints;
    private ATIModelPerformance modelPerformance;

    public List<ATIMetricDataPoint> getMetricDataPoints() {
        return this.metricDataPoints;
    }

    public void setMetricDataPoints(Collection<ATIMetricDataPoint> metricDataPoints) {
        if (metricDataPoints == null) {
            this.metricDataPoints = null;
            return;
        }
        this.metricDataPoints = new ArrayList<ATIMetricDataPoint>(metricDataPoints);
    }

    public ATITrainingMetricsValue withMetricDataPoints(ATIMetricDataPoint ... metricDataPoints) {
        if (this.metricDataPoints == null) {
            this.setMetricDataPoints(new ArrayList<ATIMetricDataPoint>(metricDataPoints.length));
        }
        for (ATIMetricDataPoint ele : metricDataPoints) {
            this.metricDataPoints.add(ele);
        }
        return this;
    }

    public ATITrainingMetricsValue withMetricDataPoints(Collection<ATIMetricDataPoint> metricDataPoints) {
        this.setMetricDataPoints(metricDataPoints);
        return this;
    }

    public void setModelPerformance(ATIModelPerformance modelPerformance) {
        this.modelPerformance = modelPerformance;
    }

    public ATIModelPerformance getModelPerformance() {
        return this.modelPerformance;
    }

    public ATITrainingMetricsValue withModelPerformance(ATIModelPerformance modelPerformance) {
        this.setModelPerformance(modelPerformance);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricDataPoints() != null) {
            sb.append("MetricDataPoints: ").append(this.getMetricDataPoints()).append(",");
        }
        if (this.getModelPerformance() != null) {
            sb.append("ModelPerformance: ").append(this.getModelPerformance());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ATITrainingMetricsValue)) {
            return false;
        }
        ATITrainingMetricsValue other = (ATITrainingMetricsValue)obj;
        if (other.getMetricDataPoints() == null ^ this.getMetricDataPoints() == null) {
            return false;
        }
        if (other.getMetricDataPoints() != null && !other.getMetricDataPoints().equals(this.getMetricDataPoints())) {
            return false;
        }
        if (other.getModelPerformance() == null ^ this.getModelPerformance() == null) {
            return false;
        }
        return other.getModelPerformance() == null || other.getModelPerformance().equals(this.getModelPerformance());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricDataPoints() == null ? 0 : this.getMetricDataPoints().hashCode());
        hashCode = 31 * hashCode + (this.getModelPerformance() == null ? 0 : this.getModelPerformance().hashCode());
        return hashCode;
    }

    public ATITrainingMetricsValue clone() {
        try {
            return (ATITrainingMetricsValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ATITrainingMetricsValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

