/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.frauddetector.AmazonFraudDetector;
import com.amazonaws.services.frauddetector.AmazonFraudDetectorClientBuilder;
import com.amazonaws.services.frauddetector.model.AmazonFraudDetectorException;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchCreateVariableResult;
import com.amazonaws.services.frauddetector.model.BatchGetVariableRequest;
import com.amazonaws.services.frauddetector.model.BatchGetVariableResult;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.CreateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.CreateModelVersionResult;
import com.amazonaws.services.frauddetector.model.CreateRuleRequest;
import com.amazonaws.services.frauddetector.model.CreateRuleResult;
import com.amazonaws.services.frauddetector.model.CreateVariableRequest;
import com.amazonaws.services.frauddetector.model.CreateVariableResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorResult;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.DeleteEventRequest;
import com.amazonaws.services.frauddetector.model.DeleteEventResult;
import com.amazonaws.services.frauddetector.model.DeleteRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.DeleteRuleVersionResult;
import com.amazonaws.services.frauddetector.model.DescribeDetectorRequest;
import com.amazonaws.services.frauddetector.model.DescribeDetectorResult;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsRequest;
import com.amazonaws.services.frauddetector.model.DescribeModelVersionsResult;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.GetDetectorsRequest;
import com.amazonaws.services.frauddetector.model.GetDetectorsResult;
import com.amazonaws.services.frauddetector.model.GetExternalModelsRequest;
import com.amazonaws.services.frauddetector.model.GetExternalModelsResult;
import com.amazonaws.services.frauddetector.model.GetModelVersionRequest;
import com.amazonaws.services.frauddetector.model.GetModelVersionResult;
import com.amazonaws.services.frauddetector.model.GetModelsRequest;
import com.amazonaws.services.frauddetector.model.GetModelsResult;
import com.amazonaws.services.frauddetector.model.GetOutcomesRequest;
import com.amazonaws.services.frauddetector.model.GetOutcomesResult;
import com.amazonaws.services.frauddetector.model.GetPredictionRequest;
import com.amazonaws.services.frauddetector.model.GetPredictionResult;
import com.amazonaws.services.frauddetector.model.GetRulesRequest;
import com.amazonaws.services.frauddetector.model.GetRulesResult;
import com.amazonaws.services.frauddetector.model.GetVariablesRequest;
import com.amazonaws.services.frauddetector.model.GetVariablesResult;
import com.amazonaws.services.frauddetector.model.PutDetectorRequest;
import com.amazonaws.services.frauddetector.model.PutDetectorResult;
import com.amazonaws.services.frauddetector.model.PutExternalModelRequest;
import com.amazonaws.services.frauddetector.model.PutExternalModelResult;
import com.amazonaws.services.frauddetector.model.PutModelRequest;
import com.amazonaws.services.frauddetector.model.PutModelResult;
import com.amazonaws.services.frauddetector.model.PutOutcomeRequest;
import com.amazonaws.services.frauddetector.model.PutOutcomeResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import com.amazonaws.services.frauddetector.model.UpdateDetectorVersionStatusResult;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateModelVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleMetadataResult;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionRequest;
import com.amazonaws.services.frauddetector.model.UpdateRuleVersionResult;
import com.amazonaws.services.frauddetector.model.UpdateVariableRequest;
import com.amazonaws.services.frauddetector.model.UpdateVariableResult;
import com.amazonaws.services.frauddetector.model.transform.BatchCreateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchCreateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchGetVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.BatchGetVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateRuleRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateRuleResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.CreateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteEventRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteEventResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteRuleVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DeleteRuleVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeModelVersionsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.DescribeModelVersionsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetDetectorsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetExternalModelsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetExternalModelsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelsRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetModelsResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetOutcomesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetOutcomesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetPredictionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetPredictionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetRulesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetRulesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetVariablesRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.GetVariablesResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutDetectorRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutDetectorResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutExternalModelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutExternalModelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutModelRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutModelResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutOutcomeRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.PutOutcomeResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionMetadataRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionMetadataResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionStatusRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateDetectorVersionStatusResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateModelVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleMetadataRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleMetadataResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleVersionRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateRuleVersionResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateVariableRequestProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.transform.UpdateVariableResultJsonUnmarshaller;
import com.amazonaws.services.frauddetector.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonFraudDetectorClient
extends AmazonWebServiceClient
implements AmazonFraudDetector {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonFraudDetector.class);
    private static final String DEFAULT_SIGNING_NAME = "frauddetector";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonFraudDetectorException.class));

    public static AmazonFraudDetectorClientBuilder builder() {
        return AmazonFraudDetectorClientBuilder.standard();
    }

    AmazonFraudDetectorClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonFraudDetectorClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("frauddetector.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/frauddetector/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/frauddetector/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCreateVariableResult batchCreateVariable(BatchCreateVariableRequest request) {
        request = (BatchCreateVariableRequest)this.beforeClientExecution(request);
        return this.executeBatchCreateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCreateVariableResult executeBatchCreateVariable(BatchCreateVariableRequest batchCreateVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCreateVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCreateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCreateVariableRequestProtocolMarshaller(protocolFactory).marshall((BatchCreateVariableRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCreateVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchCreateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCreateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCreateVariableResult batchCreateVariableResult = (BatchCreateVariableResult)response.getAwsResponse();
            return batchCreateVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public BatchGetVariableResult batchGetVariable(BatchGetVariableRequest request) {
        request = (BatchGetVariableRequest)this.beforeClientExecution(request);
        return this.executeBatchGetVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchGetVariableResult executeBatchGetVariable(BatchGetVariableRequest batchGetVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetVariableRequestProtocolMarshaller(protocolFactory).marshall((BatchGetVariableRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchGetVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetVariableResult batchGetVariableResult = (BatchGetVariableResult)response.getAwsResponse();
            return batchGetVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDetectorVersionResult createDetectorVersion(CreateDetectorVersionRequest request) {
        request = (CreateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executeCreateDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDetectorVersionResult executeCreateDetectorVersion(CreateDetectorVersionRequest createDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall((CreateDetectorVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDetectorVersionResult createDetectorVersionResult = (CreateDetectorVersionResult)response.getAwsResponse();
            return createDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateModelVersionResult createModelVersion(CreateModelVersionRequest request) {
        request = (CreateModelVersionRequest)this.beforeClientExecution(request);
        return this.executeCreateModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateModelVersionResult executeCreateModelVersion(CreateModelVersionRequest createModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateModelVersionRequestProtocolMarshaller(protocolFactory).marshall((CreateModelVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateModelVersionResult createModelVersionResult = (CreateModelVersionResult)response.getAwsResponse();
            return createModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRuleResult createRule(CreateRuleRequest request) {
        request = (CreateRuleRequest)this.beforeClientExecution(request);
        return this.executeCreateRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRuleResult executeCreateRule(CreateRuleRequest createRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRuleRequestProtocolMarshaller(protocolFactory).marshall((CreateRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRuleResult createRuleResult = (CreateRuleResult)response.getAwsResponse();
            return createRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateVariableResult createVariable(CreateVariableRequest request) {
        request = (CreateVariableRequest)this.beforeClientExecution(request);
        return this.executeCreateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateVariableResult executeCreateVariable(CreateVariableRequest createVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVariableRequestProtocolMarshaller(protocolFactory).marshall((CreateVariableRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateVariableResult createVariableResult = (CreateVariableResult)response.getAwsResponse();
            return createVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDetectorResult deleteDetector(DeleteDetectorRequest request) {
        request = (DeleteDetectorRequest)this.beforeClientExecution(request);
        return this.executeDeleteDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDetectorResult executeDeleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDetectorRequestProtocolMarshaller(protocolFactory).marshall((DeleteDetectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDetectorResult deleteDetectorResult = (DeleteDetectorResult)response.getAwsResponse();
            return deleteDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDetectorVersionResult deleteDetectorVersion(DeleteDetectorVersionRequest request) {
        request = (DeleteDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executeDeleteDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDetectorVersionResult executeDeleteDetectorVersion(DeleteDetectorVersionRequest deleteDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall((DeleteDetectorVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDetectorVersionResult deleteDetectorVersionResult = (DeleteDetectorVersionResult)response.getAwsResponse();
            return deleteDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEventResult deleteEvent(DeleteEventRequest request) {
        request = (DeleteEventRequest)this.beforeClientExecution(request);
        return this.executeDeleteEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEventResult executeDeleteEvent(DeleteEventRequest deleteEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventRequestProtocolMarshaller(protocolFactory).marshall((DeleteEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventResult deleteEventResult = (DeleteEventResult)response.getAwsResponse();
            return deleteEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRuleVersionResult deleteRuleVersion(DeleteRuleVersionRequest request) {
        request = (DeleteRuleVersionRequest)this.beforeClientExecution(request);
        return this.executeDeleteRuleVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRuleVersionResult executeDeleteRuleVersion(DeleteRuleVersionRequest deleteRuleVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleVersionRequestProtocolMarshaller(protocolFactory).marshall((DeleteRuleVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRuleVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRuleVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRuleVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRuleVersionResult deleteRuleVersionResult = (DeleteRuleVersionResult)response.getAwsResponse();
            return deleteRuleVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDetectorResult describeDetector(DescribeDetectorRequest request) {
        request = (DescribeDetectorRequest)this.beforeClientExecution(request);
        return this.executeDescribeDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeDetectorResult executeDescribeDetector(DescribeDetectorRequest describeDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDetectorRequestProtocolMarshaller(protocolFactory).marshall((DescribeDetectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeDetectorResult describeDetectorResult = (DescribeDetectorResult)response.getAwsResponse();
            return describeDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeModelVersionsResult describeModelVersions(DescribeModelVersionsRequest request) {
        request = (DescribeModelVersionsRequest)this.beforeClientExecution(request);
        return this.executeDescribeModelVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeModelVersionsResult executeDescribeModelVersions(DescribeModelVersionsRequest describeModelVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeModelVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeModelVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeModelVersionsRequestProtocolMarshaller(protocolFactory).marshall((DescribeModelVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeModelVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeModelVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeModelVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeModelVersionsResult describeModelVersionsResult = (DescribeModelVersionsResult)response.getAwsResponse();
            return describeModelVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDetectorVersionResult getDetectorVersion(GetDetectorVersionRequest request) {
        request = (GetDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executeGetDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDetectorVersionResult executeGetDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall((GetDetectorVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDetectorVersionResult getDetectorVersionResult = (GetDetectorVersionResult)response.getAwsResponse();
            return getDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDetectorsResult getDetectors(GetDetectorsRequest request) {
        request = (GetDetectorsRequest)this.beforeClientExecution(request);
        return this.executeGetDetectors(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDetectorsResult executeGetDetectors(GetDetectorsRequest getDetectorsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDetectorsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDetectorsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDetectorsRequestProtocolMarshaller(protocolFactory).marshall((GetDetectorsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDetectorsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDetectors");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDetectorsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDetectorsResult getDetectorsResult = (GetDetectorsResult)response.getAwsResponse();
            return getDetectorsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetExternalModelsResult getExternalModels(GetExternalModelsRequest request) {
        request = (GetExternalModelsRequest)this.beforeClientExecution(request);
        return this.executeGetExternalModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetExternalModelsResult executeGetExternalModels(GetExternalModelsRequest getExternalModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getExternalModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetExternalModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetExternalModelsRequestProtocolMarshaller(protocolFactory).marshall((GetExternalModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getExternalModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetExternalModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetExternalModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetExternalModelsResult getExternalModelsResult = (GetExternalModelsResult)response.getAwsResponse();
            return getExternalModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelVersionResult getModelVersion(GetModelVersionRequest request) {
        request = (GetModelVersionRequest)this.beforeClientExecution(request);
        return this.executeGetModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelVersionResult executeGetModelVersion(GetModelVersionRequest getModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelVersionRequestProtocolMarshaller(protocolFactory).marshall((GetModelVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelVersionResult getModelVersionResult = (GetModelVersionResult)response.getAwsResponse();
            return getModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetModelsResult getModels(GetModelsRequest request) {
        request = (GetModelsRequest)this.beforeClientExecution(request);
        return this.executeGetModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetModelsResult executeGetModels(GetModelsRequest getModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetModelsRequestProtocolMarshaller(protocolFactory).marshall((GetModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetModelsResult getModelsResult = (GetModelsResult)response.getAwsResponse();
            return getModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetOutcomesResult getOutcomes(GetOutcomesRequest request) {
        request = (GetOutcomesRequest)this.beforeClientExecution(request);
        return this.executeGetOutcomes(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetOutcomesResult executeGetOutcomes(GetOutcomesRequest getOutcomesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getOutcomesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetOutcomesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetOutcomesRequestProtocolMarshaller(protocolFactory).marshall((GetOutcomesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getOutcomesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetOutcomes");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetOutcomesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetOutcomesResult getOutcomesResult = (GetOutcomesResult)response.getAwsResponse();
            return getOutcomesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetPredictionResult getPrediction(GetPredictionRequest request) {
        request = (GetPredictionRequest)this.beforeClientExecution(request);
        return this.executeGetPrediction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetPredictionResult executeGetPrediction(GetPredictionRequest getPredictionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPredictionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPredictionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPredictionRequestProtocolMarshaller(protocolFactory).marshall((GetPredictionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getPredictionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetPrediction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetPredictionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetPredictionResult getPredictionResult = (GetPredictionResult)response.getAwsResponse();
            return getPredictionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRulesResult getRules(GetRulesRequest request) {
        request = (GetRulesRequest)this.beforeClientExecution(request);
        return this.executeGetRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRulesResult executeGetRules(GetRulesRequest getRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRulesRequestProtocolMarshaller(protocolFactory).marshall((GetRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRulesResult getRulesResult = (GetRulesResult)response.getAwsResponse();
            return getRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetVariablesResult getVariables(GetVariablesRequest request) {
        request = (GetVariablesRequest)this.beforeClientExecution(request);
        return this.executeGetVariables(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetVariablesResult executeGetVariables(GetVariablesRequest getVariablesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVariablesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVariablesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVariablesRequestProtocolMarshaller(protocolFactory).marshall((GetVariablesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVariablesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetVariables");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetVariablesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetVariablesResult getVariablesResult = (GetVariablesResult)response.getAwsResponse();
            return getVariablesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutDetectorResult putDetector(PutDetectorRequest request) {
        request = (PutDetectorRequest)this.beforeClientExecution(request);
        return this.executePutDetector(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutDetectorResult executePutDetector(PutDetectorRequest putDetectorRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDetectorRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDetectorRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDetectorRequestProtocolMarshaller(protocolFactory).marshall((PutDetectorRequest)super.beforeMarshalling((AmazonWebServiceRequest)putDetectorRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutDetector");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutDetectorResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutDetectorResult putDetectorResult = (PutDetectorResult)response.getAwsResponse();
            return putDetectorResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutExternalModelResult putExternalModel(PutExternalModelRequest request) {
        request = (PutExternalModelRequest)this.beforeClientExecution(request);
        return this.executePutExternalModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutExternalModelResult executePutExternalModel(PutExternalModelRequest putExternalModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putExternalModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutExternalModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutExternalModelRequestProtocolMarshaller(protocolFactory).marshall((PutExternalModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)putExternalModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutExternalModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutExternalModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutExternalModelResult putExternalModelResult = (PutExternalModelResult)response.getAwsResponse();
            return putExternalModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutModelResult putModel(PutModelRequest request) {
        request = (PutModelRequest)this.beforeClientExecution(request);
        return this.executePutModel(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutModelResult executePutModel(PutModelRequest putModelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putModelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutModelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutModelRequestProtocolMarshaller(protocolFactory).marshall((PutModelRequest)super.beforeMarshalling((AmazonWebServiceRequest)putModelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutModel");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutModelResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutModelResult putModelResult = (PutModelResult)response.getAwsResponse();
            return putModelResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutOutcomeResult putOutcome(PutOutcomeRequest request) {
        request = (PutOutcomeRequest)this.beforeClientExecution(request);
        return this.executePutOutcome(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutOutcomeResult executePutOutcome(PutOutcomeRequest putOutcomeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putOutcomeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutOutcomeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutOutcomeRequestProtocolMarshaller(protocolFactory).marshall((PutOutcomeRequest)super.beforeMarshalling((AmazonWebServiceRequest)putOutcomeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutOutcome");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutOutcomeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutOutcomeResult putOutcomeResult = (PutOutcomeResult)response.getAwsResponse();
            return putOutcomeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionResult updateDetectorVersion(UpdateDetectorVersionRequest request) {
        request = (UpdateDetectorVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionResult executeUpdateDetectorVersion(UpdateDetectorVersionRequest updateDetectorVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionRequestProtocolMarshaller(protocolFactory).marshall((UpdateDetectorVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDetectorVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDetectorVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionResult updateDetectorVersionResult = (UpdateDetectorVersionResult)response.getAwsResponse();
            return updateDetectorVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionMetadataResult updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest request) {
        request = (UpdateDetectorVersionMetadataRequest)this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersionMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionMetadataResult executeUpdateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionMetadataRequestProtocolMarshaller(protocolFactory).marshall((UpdateDetectorVersionMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDetectorVersionMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDetectorVersionMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorVersionMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionMetadataResult updateDetectorVersionMetadataResult = (UpdateDetectorVersionMetadataResult)response.getAwsResponse();
            return updateDetectorVersionMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDetectorVersionStatusResult updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest request) {
        request = (UpdateDetectorVersionStatusRequest)this.beforeClientExecution(request);
        return this.executeUpdateDetectorVersionStatus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDetectorVersionStatusResult executeUpdateDetectorVersionStatus(UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDetectorVersionStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDetectorVersionStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDetectorVersionStatusRequestProtocolMarshaller(protocolFactory).marshall((UpdateDetectorVersionStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDetectorVersionStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDetectorVersionStatus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDetectorVersionStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDetectorVersionStatusResult updateDetectorVersionStatusResult = (UpdateDetectorVersionStatusResult)response.getAwsResponse();
            return updateDetectorVersionStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateModelVersionResult updateModelVersion(UpdateModelVersionRequest request) {
        request = (UpdateModelVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateModelVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateModelVersionResult executeUpdateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateModelVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateModelVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateModelVersionRequestProtocolMarshaller(protocolFactory).marshall((UpdateModelVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateModelVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateModelVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateModelVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateModelVersionResult updateModelVersionResult = (UpdateModelVersionResult)response.getAwsResponse();
            return updateModelVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRuleMetadataResult updateRuleMetadata(UpdateRuleMetadataRequest request) {
        request = (UpdateRuleMetadataRequest)this.beforeClientExecution(request);
        return this.executeUpdateRuleMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRuleMetadataResult executeUpdateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleMetadataRequestProtocolMarshaller(protocolFactory).marshall((UpdateRuleMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRuleMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRuleMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRuleMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRuleMetadataResult updateRuleMetadataResult = (UpdateRuleMetadataResult)response.getAwsResponse();
            return updateRuleMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRuleVersionResult updateRuleVersion(UpdateRuleVersionRequest request) {
        request = (UpdateRuleVersionRequest)this.beforeClientExecution(request);
        return this.executeUpdateRuleVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRuleVersionResult executeUpdateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRuleVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRuleVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRuleVersionRequestProtocolMarshaller(protocolFactory).marshall((UpdateRuleVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRuleVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRuleVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRuleVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRuleVersionResult updateRuleVersionResult = (UpdateRuleVersionResult)response.getAwsResponse();
            return updateRuleVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateVariableResult updateVariable(UpdateVariableRequest request) {
        request = (UpdateVariableRequest)this.beforeClientExecution(request);
        return this.executeUpdateVariable(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateVariableResult executeUpdateVariable(UpdateVariableRequest updateVariableRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateVariableRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateVariableRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateVariableRequestProtocolMarshaller(protocolFactory).marshall((UpdateVariableRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateVariableRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"FraudDetector");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateVariable");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateVariableResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateVariableResult updateVariableResult = (UpdateVariableResult)response.getAwsResponse();
            return updateVariableResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

