/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.transform.AdditionalDatasetMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdditionalDataset
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Map<String, List<String>> configuration;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public AdditionalDataset withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, List<String>> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, List<String>> configuration) {
        this.configuration = configuration;
    }

    public AdditionalDataset withConfiguration(Map<String, List<String>> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public AdditionalDataset addConfigurationEntry(String key, List<String> value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, List<String>>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public AdditionalDataset clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalDataset)) {
            return false;
        }
        AdditionalDataset other = (AdditionalDataset)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        return other.getConfiguration() == null || other.getConfiguration().equals(this.getConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        return hashCode;
    }

    public AdditionalDataset clone() {
        try {
            return (AdditionalDataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdditionalDatasetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

