/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.forecast.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Metrics you can use as a baseline for comparison purposes. Use these metrics when you interpret monitoring results
 * for an auto predictor.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/forecast-2018-06-26/Baseline" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Baseline implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your predictor
     * and the metrics change.
     * </p>
     */
    private PredictorBaseline predictorBaseline;

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your predictor
     * and the metrics change.
     * </p>
     * 
     * @param predictorBaseline
     *        The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
     *        the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your
     *        predictor and the metrics change.
     */

    public void setPredictorBaseline(PredictorBaseline predictorBaseline) {
        this.predictorBaseline = predictorBaseline;
    }

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your predictor
     * and the metrics change.
     * </p>
     * 
     * @return The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
     *         for the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use
     *         your predictor and the metrics change.
     */

    public PredictorBaseline getPredictorBaseline() {
        return this.predictorBaseline;
    }

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your predictor
     * and the metrics change.
     * </p>
     * 
     * @param predictorBaseline
     *        The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
     *        the predictor you are monitoring. Use these metrics as a baseline for comparison purposes as you use your
     *        predictor and the metrics change.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Baseline withPredictorBaseline(PredictorBaseline predictorBaseline) {
        setPredictorBaseline(predictorBaseline);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPredictorBaseline() != null)
            sb.append("PredictorBaseline: ").append(getPredictorBaseline());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Baseline == false)
            return false;
        Baseline other = (Baseline) obj;
        if (other.getPredictorBaseline() == null ^ this.getPredictorBaseline() == null)
            return false;
        if (other.getPredictorBaseline() != null && other.getPredictorBaseline().equals(this.getPredictorBaseline()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPredictorBaseline() == null) ? 0 : getPredictorBaseline().hashCode());
        return hashCode;
    }

    @Override
    public Baseline clone() {
        try {
            return (Baseline) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.forecast.model.transform.BaselineMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
