/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentActionState;
import com.amazonaws.services.fis.model.transform.ExperimentActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExperimentAction
implements Serializable,
Cloneable,
StructuredPojo {
    private String actionId;
    private String description;
    private Map<String, String> parameters;
    private Map<String, String> targets;
    private List<String> startAfter;
    private ExperimentActionState state;

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getActionId() {
        return this.actionId;
    }

    public ExperimentAction withActionId(String actionId) {
        this.setActionId(actionId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ExperimentAction withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public ExperimentAction withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public ExperimentAction addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public ExperimentAction clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public Map<String, String> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, String> targets) {
        this.targets = targets;
    }

    public ExperimentAction withTargets(Map<String, String> targets) {
        this.setTargets(targets);
        return this;
    }

    public ExperimentAction addTargetsEntry(String key, String value) {
        if (null == this.targets) {
            this.targets = new HashMap<String, String>();
        }
        if (this.targets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targets.put(key, value);
        return this;
    }

    public ExperimentAction clearTargetsEntries() {
        this.targets = null;
        return this;
    }

    public List<String> getStartAfter() {
        return this.startAfter;
    }

    public void setStartAfter(Collection<String> startAfter) {
        if (startAfter == null) {
            this.startAfter = null;
            return;
        }
        this.startAfter = new ArrayList<String>(startAfter);
    }

    public ExperimentAction withStartAfter(String ... startAfter) {
        if (this.startAfter == null) {
            this.setStartAfter(new ArrayList<String>(startAfter.length));
        }
        for (String ele : startAfter) {
            this.startAfter.add(ele);
        }
        return this;
    }

    public ExperimentAction withStartAfter(Collection<String> startAfter) {
        this.setStartAfter(startAfter);
        return this;
    }

    public void setState(ExperimentActionState state) {
        this.state = state;
    }

    public ExperimentActionState getState() {
        return this.state;
    }

    public ExperimentAction withState(ExperimentActionState state) {
        this.setState(state);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionId() != null) {
            sb.append("ActionId: ").append(this.getActionId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getStartAfter() != null) {
            sb.append("StartAfter: ").append(this.getStartAfter()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentAction)) {
            return false;
        }
        ExperimentAction other = (ExperimentAction)obj;
        if (other.getActionId() == null ^ this.getActionId() == null) {
            return false;
        }
        if (other.getActionId() != null && !other.getActionId().equals(this.getActionId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getStartAfter() == null ^ this.getStartAfter() == null) {
            return false;
        }
        if (other.getStartAfter() != null && !other.getStartAfter().equals(this.getStartAfter())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        return other.getState() == null || other.getState().equals(this.getState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionId() == null ? 0 : this.getActionId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getStartAfter() == null ? 0 : this.getStartAfter().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        return hashCode;
    }

    public ExperimentAction clone() {
        try {
            return (ExperimentAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExperimentActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

