/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspace.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.finspace.model.KxDatabaseConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateKxClusterDatabasesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String environmentId;
    private String clusterName;
    private String clientToken;
    private List<KxDatabaseConfiguration> databases;

    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public UpdateKxClusterDatabasesRequest withEnvironmentId(String environmentId) {
        this.setEnvironmentId(environmentId);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public UpdateKxClusterDatabasesRequest withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateKxClusterDatabasesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<KxDatabaseConfiguration> getDatabases() {
        return this.databases;
    }

    public void setDatabases(Collection<KxDatabaseConfiguration> databases) {
        if (databases == null) {
            this.databases = null;
            return;
        }
        this.databases = new ArrayList<KxDatabaseConfiguration>(databases);
    }

    public UpdateKxClusterDatabasesRequest withDatabases(KxDatabaseConfiguration ... databases) {
        if (this.databases == null) {
            this.setDatabases(new ArrayList<KxDatabaseConfiguration>(databases.length));
        }
        for (KxDatabaseConfiguration ele : databases) {
            this.databases.add(ele);
        }
        return this;
    }

    public UpdateKxClusterDatabasesRequest withDatabases(Collection<KxDatabaseConfiguration> databases) {
        this.setDatabases(databases);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnvironmentId() != null) {
            sb.append("EnvironmentId: ").append(this.getEnvironmentId()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDatabases() != null) {
            sb.append("Databases: ").append(this.getDatabases());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKxClusterDatabasesRequest)) {
            return false;
        }
        UpdateKxClusterDatabasesRequest other = (UpdateKxClusterDatabasesRequest)obj;
        if (other.getEnvironmentId() == null ^ this.getEnvironmentId() == null) {
            return false;
        }
        if (other.getEnvironmentId() != null && !other.getEnvironmentId().equals(this.getEnvironmentId())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDatabases() == null ^ this.getDatabases() == null) {
            return false;
        }
        return other.getDatabases() == null || other.getDatabases().equals(this.getDatabases());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnvironmentId() == null ? 0 : this.getEnvironmentId().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDatabases() == null ? 0 : this.getDatabases().hashCode());
        return hashCode;
    }

    public UpdateKxClusterDatabasesRequest clone() {
        return (UpdateKxClusterDatabasesRequest)super.clone();
    }
}

