/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudwatchevents.AmazonCloudWatchEvents;
import com.amazonaws.services.cloudwatchevents.model.ConcurrentModificationException;
import com.amazonaws.services.cloudwatchevents.model.DeleteRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.DescribeRuleResult;
import com.amazonaws.services.cloudwatchevents.model.DisableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.EnableRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.InternalException;
import com.amazonaws.services.cloudwatchevents.model.InvalidEventPatternException;
import com.amazonaws.services.cloudwatchevents.model.LimitExceededException;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRuleNamesByTargetResult;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.services.cloudwatchevents.model.ListRulesResult;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.ListTargetsByRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutEventsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutEventsResult;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.services.cloudwatchevents.model.PutRuleResult;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.PutTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsRequest;
import com.amazonaws.services.cloudwatchevents.model.RemoveTargetsResult;
import com.amazonaws.services.cloudwatchevents.model.ResourceNotFoundException;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternRequest;
import com.amazonaws.services.cloudwatchevents.model.TestEventPatternResult;
import com.amazonaws.services.cloudwatchevents.model.transform.DeleteRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.DescribeRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.DescribeRuleResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.DisableRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.EnableRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListRuleNamesByTargetRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListRuleNamesByTargetResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListRulesRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListRulesResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListTargetsByRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.ListTargetsByRuleResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutEventsRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutRuleRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutRuleResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutTargetsRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.PutTargetsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.RemoveTargetsRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.RemoveTargetsResultJsonUnmarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.TestEventPatternRequestMarshaller;
import com.amazonaws.services.cloudwatchevents.model.transform.TestEventPatternResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonCloudWatchEventsClient
extends AmazonWebServiceClient
implements AmazonCloudWatchEvents {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonCloudWatchEvents.class);
    private static final String DEFAULT_SIGNING_NAME = "events";
    private static final String DEFAULT_ENDPOINT_PREFIX = "events";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonCloudWatchEventsClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonCloudWatchEventsClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudWatchEventsClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonCloudWatchEventsClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudWatchEventsClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonCloudWatchEventsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCloudWatchEventsClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ConcurrentModificationException.class, "ConcurrentModificationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidEventPatternException.class, "InvalidEventPatternException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceNotFoundException.class, "ResourceNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InternalException.class, "InternalException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("events");
        this.setEndpointPrefix("events");
        this.setEndpoint("events.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudwatchevents/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudwatchevents/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRule(DeleteRuleRequest deleteRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleRequestMarshaller().marshall((DeleteRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRuleResult describeRule(DescribeRuleRequest describeRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRuleRequestMarshaller().marshall((DescribeRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeRuleResult describeRuleResult = (DescribeRuleResult)response.getAwsResponse();
            return describeRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableRule(DisableRuleRequest disableRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableRuleRequestMarshaller().marshall((DisableRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableRule(EnableRuleRequest enableRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableRuleRequestMarshaller().marshall((EnableRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRuleNamesByTargetResult listRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRuleNamesByTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRuleNamesByTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRuleNamesByTargetRequestMarshaller().marshall((ListRuleNamesByTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRuleNamesByTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListRuleNamesByTargetResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRuleNamesByTargetResult listRuleNamesByTargetResult = (ListRuleNamesByTargetResult)response.getAwsResponse();
            return listRuleNamesByTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRulesResult listRules(ListRulesRequest listRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesRequestMarshaller().marshall((ListRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListRulesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListRulesResult listRulesResult = (ListRulesResult)response.getAwsResponse();
            return listRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTargetsByRuleResult listTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTargetsByRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTargetsByRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTargetsByRuleRequestMarshaller().marshall((ListTargetsByRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTargetsByRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListTargetsByRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTargetsByRuleResult listTargetsByRuleResult = (ListTargetsByRuleResult)response.getAwsResponse();
            return listTargetsByRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEventsResult putEvents(PutEventsRequest putEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEventsRequestMarshaller().marshall((PutEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new PutEventsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutEventsResult putEventsResult = (PutEventsResult)response.getAwsResponse();
            return putEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRuleResult putRule(PutRuleRequest putRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRuleRequestMarshaller().marshall((PutRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new PutRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutRuleResult putRuleResult = (PutRuleResult)response.getAwsResponse();
            return putRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTargetsResult putTargets(PutTargetsRequest putTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTargetsRequestMarshaller().marshall((PutTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new PutTargetsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutTargetsResult putTargetsResult = (PutTargetsResult)response.getAwsResponse();
            return putTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTargetsResult removeTargets(RemoveTargetsRequest removeTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTargetsRequestMarshaller().marshall((RemoveTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new RemoveTargetsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveTargetsResult removeTargetsResult = (RemoveTargetsResult)response.getAwsResponse();
            return removeTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestEventPatternResult testEventPattern(TestEventPatternRequest testEventPatternRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testEventPatternRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestEventPatternRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestEventPatternRequestMarshaller().marshall((TestEventPatternRequest)super.beforeMarshalling((AmazonWebServiceRequest)testEventPatternRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new TestEventPatternResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            TestEventPatternResult testEventPatternResult = (TestEventPatternResult)response.getAwsResponse();
            return testEventPatternResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        JsonErrorResponseHandlerV2 errorResponseHandler = SdkJsonProtocolFactory.createErrorResponseHandler(this.jsonErrorUnmarshallers, (boolean)false);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

