/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eventbridge.model.transform.ReplayDestinationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplayDestination
implements Serializable,
Cloneable,
StructuredPojo {
    private String arn;
    private List<String> filterArns;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public ReplayDestination withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<String> getFilterArns() {
        return this.filterArns;
    }

    public void setFilterArns(Collection<String> filterArns) {
        if (filterArns == null) {
            this.filterArns = null;
            return;
        }
        this.filterArns = new ArrayList<String>(filterArns);
    }

    public ReplayDestination withFilterArns(String ... filterArns) {
        if (this.filterArns == null) {
            this.setFilterArns(new ArrayList<String>(filterArns.length));
        }
        for (String ele : filterArns) {
            this.filterArns.add(ele);
        }
        return this;
    }

    public ReplayDestination withFilterArns(Collection<String> filterArns) {
        this.setFilterArns(filterArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getFilterArns() != null) {
            sb.append("FilterArns: ").append(this.getFilterArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplayDestination)) {
            return false;
        }
        ReplayDestination other = (ReplayDestination)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getFilterArns() == null ^ this.getFilterArns() == null) {
            return false;
        }
        return other.getFilterArns() == null || other.getFilterArns().equals(this.getFilterArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getFilterArns() == null ? 0 : this.getFilterArns().hashCode());
        return hashCode;
    }

    public ReplayDestination clone() {
        try {
            return (ReplayDestination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplayDestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

