/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eventbridge.model.EndpointEventBus;
import com.amazonaws.services.eventbridge.model.EndpointState;
import com.amazonaws.services.eventbridge.model.ReplicationConfig;
import com.amazonaws.services.eventbridge.model.RoutingConfig;
import com.amazonaws.services.eventbridge.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String arn;
    private RoutingConfig routingConfig;
    private ReplicationConfig replicationConfig;
    private List<EndpointEventBus> eventBuses;
    private String roleArn;
    private String endpointId;
    private String endpointUrl;
    private String state;
    private String stateReason;
    private Date creationTime;
    private Date lastModifiedTime;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Endpoint withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Endpoint withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Endpoint withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setRoutingConfig(RoutingConfig routingConfig) {
        this.routingConfig = routingConfig;
    }

    public RoutingConfig getRoutingConfig() {
        return this.routingConfig;
    }

    public Endpoint withRoutingConfig(RoutingConfig routingConfig) {
        this.setRoutingConfig(routingConfig);
        return this;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public Endpoint withReplicationConfig(ReplicationConfig replicationConfig) {
        this.setReplicationConfig(replicationConfig);
        return this;
    }

    public List<EndpointEventBus> getEventBuses() {
        return this.eventBuses;
    }

    public void setEventBuses(Collection<EndpointEventBus> eventBuses) {
        if (eventBuses == null) {
            this.eventBuses = null;
            return;
        }
        this.eventBuses = new ArrayList<EndpointEventBus>(eventBuses);
    }

    public Endpoint withEventBuses(EndpointEventBus ... eventBuses) {
        if (this.eventBuses == null) {
            this.setEventBuses(new ArrayList<EndpointEventBus>(eventBuses.length));
        }
        for (EndpointEventBus ele : eventBuses) {
            this.eventBuses.add(ele);
        }
        return this;
    }

    public Endpoint withEventBuses(Collection<EndpointEventBus> eventBuses) {
        this.setEventBuses(eventBuses);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Endpoint withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public Endpoint withEndpointId(String endpointId) {
        this.setEndpointId(endpointId);
        return this;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public Endpoint withEndpointUrl(String endpointUrl) {
        this.setEndpointUrl(endpointUrl);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Endpoint withState(String state) {
        this.setState(state);
        return this;
    }

    public Endpoint withState(EndpointState state) {
        this.state = state.toString();
        return this;
    }

    public void setStateReason(String stateReason) {
        this.stateReason = stateReason;
    }

    public String getStateReason() {
        return this.stateReason;
    }

    public Endpoint withStateReason(String stateReason) {
        this.setStateReason(stateReason);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Endpoint withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Endpoint withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getRoutingConfig() != null) {
            sb.append("RoutingConfig: ").append(this.getRoutingConfig()).append(",");
        }
        if (this.getReplicationConfig() != null) {
            sb.append("ReplicationConfig: ").append(this.getReplicationConfig()).append(",");
        }
        if (this.getEventBuses() != null) {
            sb.append("EventBuses: ").append(this.getEventBuses()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getEndpointId() != null) {
            sb.append("EndpointId: ").append(this.getEndpointId()).append(",");
        }
        if (this.getEndpointUrl() != null) {
            sb.append("EndpointUrl: ").append(this.getEndpointUrl()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStateReason() != null) {
            sb.append("StateReason: ").append(this.getStateReason()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getRoutingConfig() == null ^ this.getRoutingConfig() == null) {
            return false;
        }
        if (other.getRoutingConfig() != null && !other.getRoutingConfig().equals(this.getRoutingConfig())) {
            return false;
        }
        if (other.getReplicationConfig() == null ^ this.getReplicationConfig() == null) {
            return false;
        }
        if (other.getReplicationConfig() != null && !other.getReplicationConfig().equals(this.getReplicationConfig())) {
            return false;
        }
        if (other.getEventBuses() == null ^ this.getEventBuses() == null) {
            return false;
        }
        if (other.getEventBuses() != null && !other.getEventBuses().equals(this.getEventBuses())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getEndpointId() == null ^ this.getEndpointId() == null) {
            return false;
        }
        if (other.getEndpointId() != null && !other.getEndpointId().equals(this.getEndpointId())) {
            return false;
        }
        if (other.getEndpointUrl() == null ^ this.getEndpointUrl() == null) {
            return false;
        }
        if (other.getEndpointUrl() != null && !other.getEndpointUrl().equals(this.getEndpointUrl())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        return other.getLastModifiedTime() == null || other.getLastModifiedTime().equals(this.getLastModifiedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingConfig() == null ? 0 : this.getRoutingConfig().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationConfig() == null ? 0 : this.getReplicationConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEventBuses() == null ? 0 : this.getEventBuses().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointId() == null ? 0 : this.getEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointUrl() == null ? 0 : this.getEndpointUrl().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

