/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrserverless.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrserverless.model.AutoStartConfig;
import com.amazonaws.services.emrserverless.model.AutoStopConfig;
import com.amazonaws.services.emrserverless.model.InitialCapacityConfig;
import com.amazonaws.services.emrserverless.model.MaximumAllowedResources;
import com.amazonaws.services.emrserverless.model.NetworkConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateApplicationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationId;
    private String clientToken;
    private Map<String, InitialCapacityConfig> initialCapacity;
    private MaximumAllowedResources maximumCapacity;
    private AutoStartConfig autoStartConfiguration;
    private AutoStopConfig autoStopConfiguration;
    private NetworkConfiguration networkConfiguration;

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public UpdateApplicationRequest withApplicationId(String applicationId) {
        this.setApplicationId(applicationId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateApplicationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public Map<String, InitialCapacityConfig> getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public UpdateApplicationRequest withInitialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
        this.setInitialCapacity(initialCapacity);
        return this;
    }

    public UpdateApplicationRequest addInitialCapacityEntry(String key, InitialCapacityConfig value) {
        if (null == this.initialCapacity) {
            this.initialCapacity = new HashMap<String, InitialCapacityConfig>();
        }
        if (this.initialCapacity.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.initialCapacity.put(key, value);
        return this;
    }

    public UpdateApplicationRequest clearInitialCapacityEntries() {
        this.initialCapacity = null;
        return this;
    }

    public void setMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public MaximumAllowedResources getMaximumCapacity() {
        return this.maximumCapacity;
    }

    public UpdateApplicationRequest withMaximumCapacity(MaximumAllowedResources maximumCapacity) {
        this.setMaximumCapacity(maximumCapacity);
        return this;
    }

    public void setAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.autoStartConfiguration = autoStartConfiguration;
    }

    public AutoStartConfig getAutoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public UpdateApplicationRequest withAutoStartConfiguration(AutoStartConfig autoStartConfiguration) {
        this.setAutoStartConfiguration(autoStartConfiguration);
        return this;
    }

    public void setAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.autoStopConfiguration = autoStopConfiguration;
    }

    public AutoStopConfig getAutoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public UpdateApplicationRequest withAutoStopConfiguration(AutoStopConfig autoStopConfiguration) {
        this.setAutoStopConfiguration(autoStopConfiguration);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public UpdateApplicationRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationId() != null) {
            sb.append("ApplicationId: ").append(this.getApplicationId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getInitialCapacity() != null) {
            sb.append("InitialCapacity: ").append(this.getInitialCapacity()).append(",");
        }
        if (this.getMaximumCapacity() != null) {
            sb.append("MaximumCapacity: ").append(this.getMaximumCapacity()).append(",");
        }
        if (this.getAutoStartConfiguration() != null) {
            sb.append("AutoStartConfiguration: ").append(this.getAutoStartConfiguration()).append(",");
        }
        if (this.getAutoStopConfiguration() != null) {
            sb.append("AutoStopConfiguration: ").append(this.getAutoStopConfiguration()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)obj;
        if (other.getApplicationId() == null ^ this.getApplicationId() == null) {
            return false;
        }
        if (other.getApplicationId() != null && !other.getApplicationId().equals(this.getApplicationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getInitialCapacity() == null ^ this.getInitialCapacity() == null) {
            return false;
        }
        if (other.getInitialCapacity() != null && !other.getInitialCapacity().equals(this.getInitialCapacity())) {
            return false;
        }
        if (other.getMaximumCapacity() == null ^ this.getMaximumCapacity() == null) {
            return false;
        }
        if (other.getMaximumCapacity() != null && !other.getMaximumCapacity().equals(this.getMaximumCapacity())) {
            return false;
        }
        if (other.getAutoStartConfiguration() == null ^ this.getAutoStartConfiguration() == null) {
            return false;
        }
        if (other.getAutoStartConfiguration() != null && !other.getAutoStartConfiguration().equals(this.getAutoStartConfiguration())) {
            return false;
        }
        if (other.getAutoStopConfiguration() == null ^ this.getAutoStopConfiguration() == null) {
            return false;
        }
        if (other.getAutoStopConfiguration() != null && !other.getAutoStopConfiguration().equals(this.getAutoStopConfiguration())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        return other.getNetworkConfiguration() == null || other.getNetworkConfiguration().equals(this.getNetworkConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationId() == null ? 0 : this.getApplicationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getInitialCapacity() == null ? 0 : this.getInitialCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumCapacity() == null ? 0 : this.getMaximumCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStartConfiguration() == null ? 0 : this.getAutoStartConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoStopConfiguration() == null ? 0 : this.getAutoStopConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        return hashCode;
    }

    public UpdateApplicationRequest clone() {
        return (UpdateApplicationRequest)super.clone();
    }
}

