/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.AutoScalingPolicy;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.EbsConfiguration;
import com.amazonaws.services.elasticmapreduce.model.InstanceRoleType;
import com.amazonaws.services.elasticmapreduce.model.MarketType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InstanceGroupConfig
implements Serializable,
Cloneable {
    private String name;
    private String market;
    private String instanceRole;
    private String bidPrice;
    private String instanceType;
    private Integer instanceCount;
    private SdkInternalList<Configuration> configurations;
    private EbsConfiguration ebsConfiguration;
    private AutoScalingPolicy autoScalingPolicy;

    public InstanceGroupConfig() {
    }

    public InstanceGroupConfig(String instanceRole, String instanceType, Integer instanceCount) {
        this.setInstanceRole(instanceRole);
        this.setInstanceType(instanceType);
        this.setInstanceCount(instanceCount);
    }

    public InstanceGroupConfig(InstanceRoleType instanceRole, String instanceType, Integer instanceCount) {
        this.setInstanceRole(instanceRole.toString());
        this.setInstanceType(instanceType);
        this.setInstanceCount(instanceCount);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InstanceGroupConfig withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getMarket() {
        return this.market;
    }

    public InstanceGroupConfig withMarket(String market) {
        this.setMarket(market);
        return this;
    }

    public void setMarket(MarketType market) {
        this.market = market.toString();
    }

    public InstanceGroupConfig withMarket(MarketType market) {
        this.setMarket(market);
        return this;
    }

    public void setInstanceRole(String instanceRole) {
        this.instanceRole = instanceRole;
    }

    public String getInstanceRole() {
        return this.instanceRole;
    }

    public InstanceGroupConfig withInstanceRole(String instanceRole) {
        this.setInstanceRole(instanceRole);
        return this;
    }

    public void setInstanceRole(InstanceRoleType instanceRole) {
        this.instanceRole = instanceRole.toString();
    }

    public InstanceGroupConfig withInstanceRole(InstanceRoleType instanceRole) {
        this.setInstanceRole(instanceRole);
        return this;
    }

    public void setBidPrice(String bidPrice) {
        this.bidPrice = bidPrice;
    }

    public String getBidPrice() {
        return this.bidPrice;
    }

    public InstanceGroupConfig withBidPrice(String bidPrice) {
        this.setBidPrice(bidPrice);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public InstanceGroupConfig withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public InstanceGroupConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public List<Configuration> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new SdkInternalList();
        }
        return this.configurations;
    }

    public void setConfigurations(Collection<Configuration> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new SdkInternalList(configurations);
    }

    public InstanceGroupConfig withConfigurations(Configuration ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations((Collection<Configuration>)new SdkInternalList(configurations.length));
        }
        for (Configuration ele : configurations) {
            this.configurations.add((Object)ele);
        }
        return this;
    }

    public InstanceGroupConfig withConfigurations(Collection<Configuration> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public void setEbsConfiguration(EbsConfiguration ebsConfiguration) {
        this.ebsConfiguration = ebsConfiguration;
    }

    public EbsConfiguration getEbsConfiguration() {
        return this.ebsConfiguration;
    }

    public InstanceGroupConfig withEbsConfiguration(EbsConfiguration ebsConfiguration) {
        this.setEbsConfiguration(ebsConfiguration);
        return this;
    }

    public void setAutoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
        this.autoScalingPolicy = autoScalingPolicy;
    }

    public AutoScalingPolicy getAutoScalingPolicy() {
        return this.autoScalingPolicy;
    }

    public InstanceGroupConfig withAutoScalingPolicy(AutoScalingPolicy autoScalingPolicy) {
        this.setAutoScalingPolicy(autoScalingPolicy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getMarket() != null) {
            sb.append("Market: " + this.getMarket() + ",");
        }
        if (this.getInstanceRole() != null) {
            sb.append("InstanceRole: " + this.getInstanceRole() + ",");
        }
        if (this.getBidPrice() != null) {
            sb.append("BidPrice: " + this.getBidPrice() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: " + this.getConfigurations() + ",");
        }
        if (this.getEbsConfiguration() != null) {
            sb.append("EbsConfiguration: " + this.getEbsConfiguration() + ",");
        }
        if (this.getAutoScalingPolicy() != null) {
            sb.append("AutoScalingPolicy: " + this.getAutoScalingPolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupConfig)) {
            return false;
        }
        InstanceGroupConfig other = (InstanceGroupConfig)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMarket() == null ^ this.getMarket() == null) {
            return false;
        }
        if (other.getMarket() != null && !other.getMarket().equals(this.getMarket())) {
            return false;
        }
        if (other.getInstanceRole() == null ^ this.getInstanceRole() == null) {
            return false;
        }
        if (other.getInstanceRole() != null && !other.getInstanceRole().equals(this.getInstanceRole())) {
            return false;
        }
        if (other.getBidPrice() == null ^ this.getBidPrice() == null) {
            return false;
        }
        if (other.getBidPrice() != null && !other.getBidPrice().equals(this.getBidPrice())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getEbsConfiguration() == null ^ this.getEbsConfiguration() == null) {
            return false;
        }
        if (other.getEbsConfiguration() != null && !other.getEbsConfiguration().equals(this.getEbsConfiguration())) {
            return false;
        }
        if (other.getAutoScalingPolicy() == null ^ this.getAutoScalingPolicy() == null) {
            return false;
        }
        return other.getAutoScalingPolicy() == null || other.getAutoScalingPolicy().equals(this.getAutoScalingPolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMarket() == null ? 0 : this.getMarket().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceRole() == null ? 0 : this.getInstanceRole().hashCode());
        hashCode = 31 * hashCode + (this.getBidPrice() == null ? 0 : this.getBidPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEbsConfiguration() == null ? 0 : this.getEbsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingPolicy() == null ? 0 : this.getAutoScalingPolicy().hashCode());
        return hashCode;
    }

    public InstanceGroupConfig clone() {
        try {
            return (InstanceGroupConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

