/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.EbsBlockDevice;
import com.amazonaws.services.elasticmapreduce.model.transform.VolumeSpecificationJsonMarshaller;

public class EbsBlockDeviceJsonMarshaller {
    private static EbsBlockDeviceJsonMarshaller instance;

    public void marshall(EbsBlockDevice ebsBlockDevice, StructuredJsonGenerator jsonGenerator) {
        if (ebsBlockDevice == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (ebsBlockDevice.getVolumeSpecification() != null) {
                jsonGenerator.writeFieldName("VolumeSpecification");
                VolumeSpecificationJsonMarshaller.getInstance().marshall(ebsBlockDevice.getVolumeSpecification(), jsonGenerator);
            }
            if (ebsBlockDevice.getDevice() != null) {
                jsonGenerator.writeFieldName("Device").writeValue(ebsBlockDevice.getDevice());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EbsBlockDeviceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EbsBlockDeviceJsonMarshaller();
        }
        return instance;
    }
}

