/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListInstancesRequestMarshaller
implements Marshaller<Request<ListInstancesRequest>, ListInstancesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListInstancesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListInstancesRequest> marshall(ListInstancesRequest listInstancesRequest) {
        if (listInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listInstancesRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList instanceStatesList;
            SdkInternalList instanceGroupTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listInstancesRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listInstancesRequest.getClusterId());
            }
            if (listInstancesRequest.getInstanceGroupId() != null) {
                jsonGenerator.writeFieldName("InstanceGroupId").writeValue(listInstancesRequest.getInstanceGroupId());
            }
            if (!(instanceGroupTypesList = (SdkInternalList)listInstancesRequest.getInstanceGroupTypes()).isEmpty() || !instanceGroupTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceGroupTypes");
                jsonGenerator.writeStartArray();
                for (String instanceGroupTypesListValue : instanceGroupTypesList) {
                    if (instanceGroupTypesListValue == null) continue;
                    jsonGenerator.writeValue(instanceGroupTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(instanceStatesList = (SdkInternalList)listInstancesRequest.getInstanceStates()).isEmpty() || !instanceStatesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("InstanceStates");
                jsonGenerator.writeStartArray();
                for (String instanceStatesListValue : instanceStatesList) {
                    if (instanceStatesListValue == null) continue;
                    jsonGenerator.writeValue(instanceStatesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listInstancesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listInstancesRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

