/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.VolumeSpecification;
import com.amazonaws.util.json.SdkJsonGenerator;

public class VolumeSpecificationJsonMarshaller {
    private static VolumeSpecificationJsonMarshaller instance;

    public void marshall(VolumeSpecification volumeSpecification, SdkJsonGenerator jsonGenerator) {
        if (volumeSpecification == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (volumeSpecification.getVolumeType() != null) {
                jsonGenerator.writeFieldName("VolumeType").writeValue(volumeSpecification.getVolumeType());
            }
            if (volumeSpecification.getIops() != null) {
                jsonGenerator.writeFieldName("Iops").writeValue((long)volumeSpecification.getIops().intValue());
            }
            if (volumeSpecification.getSizeInGB() != null) {
                jsonGenerator.writeFieldName("SizeInGB").writeValue((long)volumeSpecification.getSizeInGB().intValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeSpecificationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeSpecificationJsonMarshaller();
        }
        return instance;
    }
}

