/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.Step;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopStepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStatusJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class StepJsonMarshaller {
    private static StepJsonMarshaller instance;

    public void marshall(Step step, SdkJsonGenerator jsonGenerator) {
        if (step == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (step.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(step.getId());
            }
            if (step.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(step.getName());
            }
            if (step.getConfig() != null) {
                jsonGenerator.writeFieldName("Config");
                HadoopStepConfigJsonMarshaller.getInstance().marshall(step.getConfig(), jsonGenerator);
            }
            if (step.getActionOnFailure() != null) {
                jsonGenerator.writeFieldName("ActionOnFailure").writeValue(step.getActionOnFailure());
            }
            if (step.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                StepStatusJsonMarshaller.getInstance().marshall(step.getStatus(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepJsonMarshaller();
        }
        return instance;
    }
}

