/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.InstanceStatus;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceStateChangeReasonJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InstanceTimelineJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class InstanceStatusJsonMarshaller {
    private static InstanceStatusJsonMarshaller instance;

    public void marshall(InstanceStatus instanceStatus, SdkJsonGenerator jsonGenerator) {
        if (instanceStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (instanceStatus.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(instanceStatus.getState());
            }
            if (instanceStatus.getStateChangeReason() != null) {
                jsonGenerator.writeFieldName("StateChangeReason");
                InstanceStateChangeReasonJsonMarshaller.getInstance().marshall(instanceStatus.getStateChangeReason(), jsonGenerator);
            }
            if (instanceStatus.getTimeline() != null) {
                jsonGenerator.writeFieldName("Timeline");
                InstanceTimelineJsonMarshaller.getInstance().marshall(instanceStatus.getTimeline(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceStatusJsonMarshaller();
        }
        return instance;
    }
}

