/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.Application;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig;
import com.amazonaws.services.elasticmapreduce.model.Tag;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class RunJobFlowRequestMarshaller
implements Marshaller<Request<RunJobFlowRequest>, RunJobFlowRequest> {
    public Request<RunJobFlowRequest> marshall(RunJobFlowRequest runJobFlowRequest) {
        if (runJobFlowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runJobFlowRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.RunJobFlow";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag tagsList;
            ListWithAutoConstructFlag configurationsList;
            ListWithAutoConstructFlag applicationsList;
            ListWithAutoConstructFlag newSupportedProductsList;
            ListWithAutoConstructFlag supportedProductsList;
            ListWithAutoConstructFlag bootstrapActionsList;
            ListWithAutoConstructFlag argsList;
            ListWithAutoConstructFlag stepsList;
            JobFlowInstancesConfig instances;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (runJobFlowRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)runJobFlowRequest.getName());
            }
            if (runJobFlowRequest.getLogUri() != null) {
                jsonWriter.key("LogUri").value((Object)runJobFlowRequest.getLogUri());
            }
            if (runJobFlowRequest.getAdditionalInfo() != null) {
                jsonWriter.key("AdditionalInfo").value((Object)runJobFlowRequest.getAdditionalInfo());
            }
            if (runJobFlowRequest.getAmiVersion() != null) {
                jsonWriter.key("AmiVersion").value((Object)runJobFlowRequest.getAmiVersion());
            }
            if (runJobFlowRequest.getReleaseLabel() != null) {
                jsonWriter.key("ReleaseLabel").value((Object)runJobFlowRequest.getReleaseLabel());
            }
            if ((instances = runJobFlowRequest.getInstances()) != null) {
                ListWithAutoConstructFlag additionalSlaveSecurityGroupsList;
                ListWithAutoConstructFlag additionalMasterSecurityGroupsList;
                PlacementType placement;
                ListWithAutoConstructFlag instanceGroupsList;
                jsonWriter.key("Instances");
                jsonWriter.object();
                if (instances.getMasterInstanceType() != null) {
                    jsonWriter.key("MasterInstanceType").value((Object)instances.getMasterInstanceType());
                }
                if (instances.getSlaveInstanceType() != null) {
                    jsonWriter.key("SlaveInstanceType").value((Object)instances.getSlaveInstanceType());
                }
                if (instances.getInstanceCount() != null) {
                    jsonWriter.key("InstanceCount").value((Object)instances.getInstanceCount());
                }
                if (!((instanceGroupsList = (ListWithAutoConstructFlag)instances.getInstanceGroups()) == null || instanceGroupsList.isAutoConstruct() && instanceGroupsList.isEmpty())) {
                    jsonWriter.key("InstanceGroups");
                    jsonWriter.array();
                    for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
                        ListWithAutoConstructFlag configurationsList2;
                        if (instanceGroupsListValue == null) continue;
                        jsonWriter.object();
                        if (instanceGroupsListValue.getName() != null) {
                            jsonWriter.key("Name").value((Object)instanceGroupsListValue.getName());
                        }
                        if (instanceGroupsListValue.getMarket() != null) {
                            jsonWriter.key("Market").value((Object)instanceGroupsListValue.getMarket());
                        }
                        if (instanceGroupsListValue.getInstanceRole() != null) {
                            jsonWriter.key("InstanceRole").value((Object)instanceGroupsListValue.getInstanceRole());
                        }
                        if (instanceGroupsListValue.getBidPrice() != null) {
                            jsonWriter.key("BidPrice").value((Object)instanceGroupsListValue.getBidPrice());
                        }
                        if (instanceGroupsListValue.getInstanceType() != null) {
                            jsonWriter.key("InstanceType").value((Object)instanceGroupsListValue.getInstanceType());
                        }
                        if (instanceGroupsListValue.getInstanceCount() != null) {
                            jsonWriter.key("InstanceCount").value((Object)instanceGroupsListValue.getInstanceCount());
                        }
                        if (!((configurationsList2 = (ListWithAutoConstructFlag)instanceGroupsListValue.getConfigurations()) == null || configurationsList2.isAutoConstruct() && configurationsList2.isEmpty())) {
                            jsonWriter.key("Configurations");
                            jsonWriter.array();
                            for (Configuration configurationsListValue : configurationsList2) {
                                if (configurationsListValue == null) continue;
                                ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                if (instances.getEc2KeyName() != null) {
                    jsonWriter.key("Ec2KeyName").value((Object)instances.getEc2KeyName());
                }
                if ((placement = instances.getPlacement()) != null) {
                    jsonWriter.key("Placement");
                    jsonWriter.object();
                    if (placement.getAvailabilityZone() != null) {
                        jsonWriter.key("AvailabilityZone").value((Object)placement.getAvailabilityZone());
                    }
                    jsonWriter.endObject();
                }
                if (instances.isKeepJobFlowAliveWhenNoSteps() != null) {
                    jsonWriter.key("KeepJobFlowAliveWhenNoSteps").value((Object)instances.isKeepJobFlowAliveWhenNoSteps());
                }
                if (instances.isTerminationProtected() != null) {
                    jsonWriter.key("TerminationProtected").value((Object)instances.isTerminationProtected());
                }
                if (instances.getHadoopVersion() != null) {
                    jsonWriter.key("HadoopVersion").value((Object)instances.getHadoopVersion());
                }
                if (instances.getEc2SubnetId() != null) {
                    jsonWriter.key("Ec2SubnetId").value((Object)instances.getEc2SubnetId());
                }
                if (instances.getEmrManagedMasterSecurityGroup() != null) {
                    jsonWriter.key("EmrManagedMasterSecurityGroup").value((Object)instances.getEmrManagedMasterSecurityGroup());
                }
                if (instances.getEmrManagedSlaveSecurityGroup() != null) {
                    jsonWriter.key("EmrManagedSlaveSecurityGroup").value((Object)instances.getEmrManagedSlaveSecurityGroup());
                }
                if (!((additionalMasterSecurityGroupsList = (ListWithAutoConstructFlag)instances.getAdditionalMasterSecurityGroups()) == null || additionalMasterSecurityGroupsList.isAutoConstruct() && additionalMasterSecurityGroupsList.isEmpty())) {
                    jsonWriter.key("AdditionalMasterSecurityGroups");
                    jsonWriter.array();
                    for (String additionalMasterSecurityGroupsListValue : additionalMasterSecurityGroupsList) {
                        if (additionalMasterSecurityGroupsListValue == null) continue;
                        jsonWriter.value((Object)additionalMasterSecurityGroupsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((additionalSlaveSecurityGroupsList = (ListWithAutoConstructFlag)instances.getAdditionalSlaveSecurityGroups()) == null || additionalSlaveSecurityGroupsList.isAutoConstruct() && additionalSlaveSecurityGroupsList.isEmpty())) {
                    jsonWriter.key("AdditionalSlaveSecurityGroups");
                    jsonWriter.array();
                    for (String additionalSlaveSecurityGroupsListValue : additionalSlaveSecurityGroupsList) {
                        if (additionalSlaveSecurityGroupsListValue == null) continue;
                        jsonWriter.value((Object)additionalSlaveSecurityGroupsListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (!((stepsList = (ListWithAutoConstructFlag)runJobFlowRequest.getSteps()) == null || stepsList.isAutoConstruct() && stepsList.isEmpty())) {
                jsonWriter.key("Steps");
                jsonWriter.array();
                for (StepConfig stepsListValue : stepsList) {
                    HadoopJarStepConfig hadoopJarStep;
                    if (stepsListValue == null) continue;
                    jsonWriter.object();
                    if (stepsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)stepsListValue.getName());
                    }
                    if (stepsListValue.getActionOnFailure() != null) {
                        jsonWriter.key("ActionOnFailure").value((Object)stepsListValue.getActionOnFailure());
                    }
                    if ((hadoopJarStep = stepsListValue.getHadoopJarStep()) != null) {
                        jsonWriter.key("HadoopJarStep");
                        jsonWriter.object();
                        ListWithAutoConstructFlag propertiesList = (ListWithAutoConstructFlag)hadoopJarStep.getProperties();
                        if (!(propertiesList == null || propertiesList.isAutoConstruct() && propertiesList.isEmpty())) {
                            jsonWriter.key("Properties");
                            jsonWriter.array();
                            for (KeyValue propertiesListValue : propertiesList) {
                                if (propertiesListValue == null) continue;
                                jsonWriter.object();
                                if (propertiesListValue.getKey() != null) {
                                    jsonWriter.key("Key").value((Object)propertiesListValue.getKey());
                                }
                                if (propertiesListValue.getValue() != null) {
                                    jsonWriter.key("Value").value((Object)propertiesListValue.getValue());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if (hadoopJarStep.getJar() != null) {
                            jsonWriter.key("Jar").value((Object)hadoopJarStep.getJar());
                        }
                        if (hadoopJarStep.getMainClass() != null) {
                            jsonWriter.key("MainClass").value((Object)hadoopJarStep.getMainClass());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)hadoopJarStep.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            for (String argsListValue : argsList) {
                                if (argsListValue == null) continue;
                                jsonWriter.value((Object)argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((bootstrapActionsList = (ListWithAutoConstructFlag)runJobFlowRequest.getBootstrapActions()) == null || bootstrapActionsList.isAutoConstruct() && bootstrapActionsList.isEmpty())) {
                jsonWriter.key("BootstrapActions");
                jsonWriter.array();
                for (BootstrapActionConfig bootstrapActionsListValue : bootstrapActionsList) {
                    ScriptBootstrapActionConfig scriptBootstrapAction;
                    if (bootstrapActionsListValue == null) continue;
                    jsonWriter.object();
                    if (bootstrapActionsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)bootstrapActionsListValue.getName());
                    }
                    if ((scriptBootstrapAction = bootstrapActionsListValue.getScriptBootstrapAction()) != null) {
                        jsonWriter.key("ScriptBootstrapAction");
                        jsonWriter.object();
                        if (scriptBootstrapAction.getPath() != null) {
                            jsonWriter.key("Path").value((Object)scriptBootstrapAction.getPath());
                        }
                        if (!((argsList = (ListWithAutoConstructFlag)scriptBootstrapAction.getArgs()) == null || argsList.isAutoConstruct() && argsList.isEmpty())) {
                            jsonWriter.key("Args");
                            jsonWriter.array();
                            for (String argsListValue : argsList) {
                                if (argsListValue == null) continue;
                                jsonWriter.value((Object)argsListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((supportedProductsList = (ListWithAutoConstructFlag)runJobFlowRequest.getSupportedProducts()) == null || supportedProductsList.isAutoConstruct() && supportedProductsList.isEmpty())) {
                jsonWriter.key("SupportedProducts");
                jsonWriter.array();
                for (String supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonWriter.value((Object)supportedProductsListValue);
                }
                jsonWriter.endArray();
            }
            if (!((newSupportedProductsList = (ListWithAutoConstructFlag)runJobFlowRequest.getNewSupportedProducts()) == null || newSupportedProductsList.isAutoConstruct() && newSupportedProductsList.isEmpty())) {
                jsonWriter.key("NewSupportedProducts");
                jsonWriter.array();
                for (SupportedProductConfig newSupportedProductsListValue : newSupportedProductsList) {
                    ListWithAutoConstructFlag argsList2;
                    if (newSupportedProductsListValue == null) continue;
                    jsonWriter.object();
                    if (newSupportedProductsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)newSupportedProductsListValue.getName());
                    }
                    if (!((argsList2 = (ListWithAutoConstructFlag)newSupportedProductsListValue.getArgs()) == null || argsList2.isAutoConstruct() && argsList2.isEmpty())) {
                        jsonWriter.key("Args");
                        jsonWriter.array();
                        for (String argsListValue : argsList2) {
                            if (argsListValue == null) continue;
                            jsonWriter.value((Object)argsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((applicationsList = (ListWithAutoConstructFlag)runJobFlowRequest.getApplications()) == null || applicationsList.isAutoConstruct() && applicationsList.isEmpty())) {
                jsonWriter.key("Applications");
                jsonWriter.array();
                for (Application applicationsListValue : applicationsList) {
                    ListWithAutoConstructFlag argsList3;
                    if (applicationsListValue == null) continue;
                    jsonWriter.object();
                    if (applicationsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)applicationsListValue.getName());
                    }
                    if (applicationsListValue.getVersion() != null) {
                        jsonWriter.key("Version").value((Object)applicationsListValue.getVersion());
                    }
                    if (!((argsList3 = (ListWithAutoConstructFlag)applicationsListValue.getArgs()) == null || argsList3.isAutoConstruct() && argsList3.isEmpty())) {
                        jsonWriter.key("Args");
                        jsonWriter.array();
                        for (String argsListValue : argsList3) {
                            if (argsListValue == null) continue;
                            jsonWriter.value((Object)argsListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if (applicationsListValue.getAdditionalInfo() != null) {
                        jsonWriter.key("AdditionalInfo");
                        jsonWriter.object();
                        for (Map.Entry<String, String> additionalInfoListValue : applicationsListValue.getAdditionalInfo().entrySet()) {
                            if (additionalInfoListValue.getValue() == null) continue;
                            jsonWriter.key(additionalInfoListValue.getKey());
                            jsonWriter.value((Object)additionalInfoListValue.getValue());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (!((configurationsList = (ListWithAutoConstructFlag)runJobFlowRequest.getConfigurations()) == null || configurationsList.isAutoConstruct() && configurationsList.isEmpty())) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (runJobFlowRequest.isVisibleToAllUsers() != null) {
                jsonWriter.key("VisibleToAllUsers").value((Object)runJobFlowRequest.isVisibleToAllUsers());
            }
            if (runJobFlowRequest.getJobFlowRole() != null) {
                jsonWriter.key("JobFlowRole").value((Object)runJobFlowRequest.getJobFlowRole());
            }
            if (runJobFlowRequest.getServiceRole() != null) {
                jsonWriter.key("ServiceRole").value((Object)runJobFlowRequest.getServiceRole());
            }
            if (!((tagsList = (ListWithAutoConstructFlag)runJobFlowRequest.getTags()) == null || tagsList.isAutoConstruct() && tagsList.isEmpty())) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    jsonWriter.object();
                    if (tagsListValue.getKey() != null) {
                        jsonWriter.key("Key").value((Object)tagsListValue.getKey());
                    }
                    if (tagsListValue.getValue() != null) {
                        jsonWriter.key("Value").value((Object)tagsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

