/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class ConfigurationJsonMarshaller {
    private static ConfigurationJsonMarshaller instance;

    public void marshall(Configuration configuration, JSONWriter jsonWriter) {
        if (configuration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap propertiesMap;
            SdkInternalList configurationsList;
            jsonWriter.object();
            if (configuration.getClassification() != null) {
                jsonWriter.key("Classification").value((Object)configuration.getClassification());
            }
            if (!(configurationsList = (SdkInternalList)configuration.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (!(propertiesMap = (SdkInternalMap)configuration.getProperties()).isEmpty() || !propertiesMap.isAutoConstruct()) {
                jsonWriter.key("Properties");
                jsonWriter.object();
                for (Map.Entry propertiesMapValue : propertiesMap.entrySet()) {
                    if (propertiesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)propertiesMapValue.getKey());
                    jsonWriter.value(propertiesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationJsonMarshaller();
        }
        return instance;
    }
}

