/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;

public class CaptionSourceJsonMarshaller {
    private static CaptionSourceJsonMarshaller instance;

    public void marshall(CaptionSource captionSource, StructuredJsonGenerator jsonGenerator) {
        if (captionSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (captionSource.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(captionSource.getKey());
            }
            if (captionSource.getLanguage() != null) {
                jsonGenerator.writeFieldName("Language").writeValue(captionSource.getLanguage());
            }
            if (captionSource.getTimeOffset() != null) {
                jsonGenerator.writeFieldName("TimeOffset").writeValue(captionSource.getTimeOffset());
            }
            if (captionSource.getLabel() != null) {
                jsonGenerator.writeFieldName("Label").writeValue(captionSource.getLabel());
            }
            if (captionSource.getEncryption() != null) {
                jsonGenerator.writeFieldName("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(captionSource.getEncryption(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionSourceJsonMarshaller();
        }
        return instance;
    }
}

