/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.transform.AudioParametersJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ThumbnailsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.VideoParametersJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreatePresetRequestMarshaller
implements Marshaller<Request<CreatePresetRequest>, CreatePresetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreatePresetRequest> marshall(CreatePresetRequest createPresetRequest) {
        if (createPresetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPresetRequest, "AmazonElasticTranscoder");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2012-09-25/presets";
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createPresetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createPresetRequest.getName());
            }
            if (createPresetRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createPresetRequest.getDescription());
            }
            if (createPresetRequest.getContainer() != null) {
                jsonGenerator.writeFieldName("Container").writeValue(createPresetRequest.getContainer());
            }
            if (createPresetRequest.getVideo() != null) {
                jsonGenerator.writeFieldName("Video");
                VideoParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getVideo(), (StructuredJsonGenerator)jsonGenerator);
            }
            if (createPresetRequest.getAudio() != null) {
                jsonGenerator.writeFieldName("Audio");
                AudioParametersJsonMarshaller.getInstance().marshall(createPresetRequest.getAudio(), (StructuredJsonGenerator)jsonGenerator);
            }
            if (createPresetRequest.getThumbnails() != null) {
                jsonGenerator.writeFieldName("Thumbnails");
                ThumbnailsJsonMarshaller.getInstance().marshall(createPresetRequest.getThumbnails(), (StructuredJsonGenerator)jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

