/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elastictranscoder.model.PresetWatermark;
import com.amazonaws.services.elastictranscoder.model.VideoParameters;
import com.amazonaws.services.elastictranscoder.model.transform.PresetWatermarkJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class VideoParametersJsonMarshaller {
    private static VideoParametersJsonMarshaller instance;

    public void marshall(VideoParameters videoParameters, JSONWriter jsonWriter) {
        if (videoParameters == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList watermarksList;
            SdkInternalMap codecOptionsMap;
            jsonWriter.object();
            if (videoParameters.getCodec() != null) {
                jsonWriter.key("Codec").value((Object)videoParameters.getCodec());
            }
            if (!(codecOptionsMap = (SdkInternalMap)videoParameters.getCodecOptions()).isEmpty() || !codecOptionsMap.isAutoConstruct()) {
                jsonWriter.key("CodecOptions");
                jsonWriter.object();
                for (Map.Entry codecOptionsMapValue : codecOptionsMap.entrySet()) {
                    if (codecOptionsMapValue.getValue() == null) continue;
                    jsonWriter.key((String)codecOptionsMapValue.getKey());
                    jsonWriter.value(codecOptionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (videoParameters.getKeyframesMaxDist() != null) {
                jsonWriter.key("KeyframesMaxDist").value((Object)videoParameters.getKeyframesMaxDist());
            }
            if (videoParameters.getFixedGOP() != null) {
                jsonWriter.key("FixedGOP").value((Object)videoParameters.getFixedGOP());
            }
            if (videoParameters.getBitRate() != null) {
                jsonWriter.key("BitRate").value((Object)videoParameters.getBitRate());
            }
            if (videoParameters.getFrameRate() != null) {
                jsonWriter.key("FrameRate").value((Object)videoParameters.getFrameRate());
            }
            if (videoParameters.getMaxFrameRate() != null) {
                jsonWriter.key("MaxFrameRate").value((Object)videoParameters.getMaxFrameRate());
            }
            if (videoParameters.getResolution() != null) {
                jsonWriter.key("Resolution").value((Object)videoParameters.getResolution());
            }
            if (videoParameters.getAspectRatio() != null) {
                jsonWriter.key("AspectRatio").value((Object)videoParameters.getAspectRatio());
            }
            if (videoParameters.getMaxWidth() != null) {
                jsonWriter.key("MaxWidth").value((Object)videoParameters.getMaxWidth());
            }
            if (videoParameters.getMaxHeight() != null) {
                jsonWriter.key("MaxHeight").value((Object)videoParameters.getMaxHeight());
            }
            if (videoParameters.getDisplayAspectRatio() != null) {
                jsonWriter.key("DisplayAspectRatio").value((Object)videoParameters.getDisplayAspectRatio());
            }
            if (videoParameters.getSizingPolicy() != null) {
                jsonWriter.key("SizingPolicy").value((Object)videoParameters.getSizingPolicy());
            }
            if (videoParameters.getPaddingPolicy() != null) {
                jsonWriter.key("PaddingPolicy").value((Object)videoParameters.getPaddingPolicy());
            }
            if (!(watermarksList = (SdkInternalList)videoParameters.getWatermarks()).isEmpty() || !watermarksList.isAutoConstruct()) {
                jsonWriter.key("Watermarks");
                jsonWriter.array();
                for (PresetWatermark watermarksListValue : watermarksList) {
                    if (watermarksListValue == null) continue;
                    PresetWatermarkJsonMarshaller.getInstance().marshall(watermarksListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VideoParametersJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VideoParametersJsonMarshaller();
        }
        return instance;
    }
}

