/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.elasticsearch.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AdvancedSecurityOptionsInputMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AdvancedSecurityOptionsInputMarshaller {

    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Enabled").build();
    private static final MarshallingInfo<Boolean> INTERNALUSERDATABASEENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InternalUserDatabaseEnabled").build();
    private static final MarshallingInfo<StructuredPojo> MASTERUSEROPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterUserOptions").build();
    private static final MarshallingInfo<StructuredPojo> SAMLOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SAMLOptions").build();
    private static final MarshallingInfo<Boolean> ANONYMOUSAUTHENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AnonymousAuthEnabled").build();

    private static final AdvancedSecurityOptionsInputMarshaller instance = new AdvancedSecurityOptionsInputMarshaller();

    public static AdvancedSecurityOptionsInputMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AdvancedSecurityOptionsInput advancedSecurityOptionsInput, ProtocolMarshaller protocolMarshaller) {

        if (advancedSecurityOptionsInput == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(advancedSecurityOptionsInput.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptionsInput.getInternalUserDatabaseEnabled(), INTERNALUSERDATABASEENABLED_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptionsInput.getMasterUserOptions(), MASTERUSEROPTIONS_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptionsInput.getSAMLOptions(), SAMLOPTIONS_BINDING);
            protocolMarshaller.marshall(advancedSecurityOptionsInput.getAnonymousAuthEnabled(), ANONYMOUSAUTHENABLED_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
