/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticsearch.model.DeploymentStatus;
import com.amazonaws.services.elasticsearch.model.transform.ServiceSoftwareOptionsMarshaller;
import java.io.Serializable;
import java.util.Date;

public class ServiceSoftwareOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private String currentVersion;
    private String newVersion;
    private Boolean updateAvailable;
    private Boolean cancellable;
    private String updateStatus;
    private String description;
    private Date automatedUpdateDate;
    private Boolean optionalDeployment;

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public ServiceSoftwareOptions withCurrentVersion(String currentVersion) {
        this.setCurrentVersion(currentVersion);
        return this;
    }

    public void setNewVersion(String newVersion) {
        this.newVersion = newVersion;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public ServiceSoftwareOptions withNewVersion(String newVersion) {
        this.setNewVersion(newVersion);
        return this;
    }

    public void setUpdateAvailable(Boolean updateAvailable) {
        this.updateAvailable = updateAvailable;
    }

    public Boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    public ServiceSoftwareOptions withUpdateAvailable(Boolean updateAvailable) {
        this.setUpdateAvailable(updateAvailable);
        return this;
    }

    public Boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public void setCancellable(Boolean cancellable) {
        this.cancellable = cancellable;
    }

    public Boolean getCancellable() {
        return this.cancellable;
    }

    public ServiceSoftwareOptions withCancellable(Boolean cancellable) {
        this.setCancellable(cancellable);
        return this;
    }

    public Boolean isCancellable() {
        return this.cancellable;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    public String getUpdateStatus() {
        return this.updateStatus;
    }

    public ServiceSoftwareOptions withUpdateStatus(String updateStatus) {
        this.setUpdateStatus(updateStatus);
        return this;
    }

    public ServiceSoftwareOptions withUpdateStatus(DeploymentStatus updateStatus) {
        this.updateStatus = updateStatus.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ServiceSoftwareOptions withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setAutomatedUpdateDate(Date automatedUpdateDate) {
        this.automatedUpdateDate = automatedUpdateDate;
    }

    public Date getAutomatedUpdateDate() {
        return this.automatedUpdateDate;
    }

    public ServiceSoftwareOptions withAutomatedUpdateDate(Date automatedUpdateDate) {
        this.setAutomatedUpdateDate(automatedUpdateDate);
        return this;
    }

    public void setOptionalDeployment(Boolean optionalDeployment) {
        this.optionalDeployment = optionalDeployment;
    }

    public Boolean getOptionalDeployment() {
        return this.optionalDeployment;
    }

    public ServiceSoftwareOptions withOptionalDeployment(Boolean optionalDeployment) {
        this.setOptionalDeployment(optionalDeployment);
        return this;
    }

    public Boolean isOptionalDeployment() {
        return this.optionalDeployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrentVersion() != null) {
            sb.append("CurrentVersion: ").append(this.getCurrentVersion()).append(",");
        }
        if (this.getNewVersion() != null) {
            sb.append("NewVersion: ").append(this.getNewVersion()).append(",");
        }
        if (this.getUpdateAvailable() != null) {
            sb.append("UpdateAvailable: ").append(this.getUpdateAvailable()).append(",");
        }
        if (this.getCancellable() != null) {
            sb.append("Cancellable: ").append(this.getCancellable()).append(",");
        }
        if (this.getUpdateStatus() != null) {
            sb.append("UpdateStatus: ").append(this.getUpdateStatus()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getAutomatedUpdateDate() != null) {
            sb.append("AutomatedUpdateDate: ").append(this.getAutomatedUpdateDate()).append(",");
        }
        if (this.getOptionalDeployment() != null) {
            sb.append("OptionalDeployment: ").append(this.getOptionalDeployment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSoftwareOptions)) {
            return false;
        }
        ServiceSoftwareOptions other = (ServiceSoftwareOptions)obj;
        if (other.getCurrentVersion() == null ^ this.getCurrentVersion() == null) {
            return false;
        }
        if (other.getCurrentVersion() != null && !other.getCurrentVersion().equals(this.getCurrentVersion())) {
            return false;
        }
        if (other.getNewVersion() == null ^ this.getNewVersion() == null) {
            return false;
        }
        if (other.getNewVersion() != null && !other.getNewVersion().equals(this.getNewVersion())) {
            return false;
        }
        if (other.getUpdateAvailable() == null ^ this.getUpdateAvailable() == null) {
            return false;
        }
        if (other.getUpdateAvailable() != null && !other.getUpdateAvailable().equals(this.getUpdateAvailable())) {
            return false;
        }
        if (other.getCancellable() == null ^ this.getCancellable() == null) {
            return false;
        }
        if (other.getCancellable() != null && !other.getCancellable().equals(this.getCancellable())) {
            return false;
        }
        if (other.getUpdateStatus() == null ^ this.getUpdateStatus() == null) {
            return false;
        }
        if (other.getUpdateStatus() != null && !other.getUpdateStatus().equals(this.getUpdateStatus())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getAutomatedUpdateDate() == null ^ this.getAutomatedUpdateDate() == null) {
            return false;
        }
        if (other.getAutomatedUpdateDate() != null && !other.getAutomatedUpdateDate().equals(this.getAutomatedUpdateDate())) {
            return false;
        }
        if (other.getOptionalDeployment() == null ^ this.getOptionalDeployment() == null) {
            return false;
        }
        return other.getOptionalDeployment() == null || other.getOptionalDeployment().equals(this.getOptionalDeployment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrentVersion() == null ? 0 : this.getCurrentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getNewVersion() == null ? 0 : this.getNewVersion().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateAvailable() == null ? 0 : this.getUpdateAvailable().hashCode());
        hashCode = 31 * hashCode + (this.getCancellable() == null ? 0 : this.getCancellable().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateStatus() == null ? 0 : this.getUpdateStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedUpdateDate() == null ? 0 : this.getAutomatedUpdateDate().hashCode());
        hashCode = 31 * hashCode + (this.getOptionalDeployment() == null ? 0 : this.getOptionalDeployment().hashCode());
        return hashCode;
    }

    public ServiceSoftwareOptions clone() {
        try {
            return (ServiceSoftwareOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceSoftwareOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

