/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.elasticsearch.model.ListTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListTagsRequestMarshaller
implements Marshaller<Request<ListTagsRequest>, ListTagsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListTagsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListTagsRequest> marshall(ListTagsRequest listTagsRequest) {
        if (listTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listTagsRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-01-01/tags/";
        request.setResourcePath(uriResourcePath);
        if (listTagsRequest.getARN() != null) {
            request.addParameter("arn", StringUtils.fromString((String)listTagsRequest.getARN()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

