/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticsearch.model.PackageSource;
import com.amazonaws.services.elasticsearch.model.PackageType;
import java.io.Serializable;

public class CreatePackageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String packageName;
    private String packageType;
    private String packageDescription;
    private PackageSource packageSource;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public CreatePackageRequest withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public CreatePackageRequest withPackageType(String packageType) {
        this.setPackageType(packageType);
        return this;
    }

    public CreatePackageRequest withPackageType(PackageType packageType) {
        this.packageType = packageType.toString();
        return this;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public String getPackageDescription() {
        return this.packageDescription;
    }

    public CreatePackageRequest withPackageDescription(String packageDescription) {
        this.setPackageDescription(packageDescription);
        return this;
    }

    public void setPackageSource(PackageSource packageSource) {
        this.packageSource = packageSource;
    }

    public PackageSource getPackageSource() {
        return this.packageSource;
    }

    public CreatePackageRequest withPackageSource(PackageSource packageSource) {
        this.setPackageSource(packageSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getPackageType() != null) {
            sb.append("PackageType: ").append(this.getPackageType()).append(",");
        }
        if (this.getPackageDescription() != null) {
            sb.append("PackageDescription: ").append(this.getPackageDescription()).append(",");
        }
        if (this.getPackageSource() != null) {
            sb.append("PackageSource: ").append(this.getPackageSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest)obj;
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getPackageType() == null ^ this.getPackageType() == null) {
            return false;
        }
        if (other.getPackageType() != null && !other.getPackageType().equals(this.getPackageType())) {
            return false;
        }
        if (other.getPackageDescription() == null ^ this.getPackageDescription() == null) {
            return false;
        }
        if (other.getPackageDescription() != null && !other.getPackageDescription().equals(this.getPackageDescription())) {
            return false;
        }
        if (other.getPackageSource() == null ^ this.getPackageSource() == null) {
            return false;
        }
        return other.getPackageSource() == null || other.getPackageSource().equals(this.getPackageSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getPackageType() == null ? 0 : this.getPackageType().hashCode());
        hashCode = 31 * hashCode + (this.getPackageDescription() == null ? 0 : this.getPackageDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPackageSource() == null ? 0 : this.getPackageSource().hashCode());
        return hashCode;
    }

    public CreatePackageRequest clone() {
        return (CreatePackageRequest)super.clone();
    }
}

