/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticsearch.model.ElasticsearchDomainConfig;
import com.amazonaws.services.elasticsearch.model.transform.AccessPoliciesStatusJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.AdvancedOptionsStatusJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsStatusJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigStatusJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchVersionStatusJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsStatusJsonMarshaller;

public class ElasticsearchDomainConfigJsonMarshaller {
    private static ElasticsearchDomainConfigJsonMarshaller instance;

    public void marshall(ElasticsearchDomainConfig elasticsearchDomainConfig, StructuredJsonGenerator jsonGenerator) {
        if (elasticsearchDomainConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (elasticsearchDomainConfig.getElasticsearchVersion() != null) {
                jsonGenerator.writeFieldName("ElasticsearchVersion");
                ElasticsearchVersionStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getElasticsearchVersion(), jsonGenerator);
            }
            if (elasticsearchDomainConfig.getElasticsearchClusterConfig() != null) {
                jsonGenerator.writeFieldName("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getElasticsearchClusterConfig(), jsonGenerator);
            }
            if (elasticsearchDomainConfig.getEBSOptions() != null) {
                jsonGenerator.writeFieldName("EBSOptions");
                EBSOptionsStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getEBSOptions(), jsonGenerator);
            }
            if (elasticsearchDomainConfig.getAccessPolicies() != null) {
                jsonGenerator.writeFieldName("AccessPolicies");
                AccessPoliciesStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getAccessPolicies(), jsonGenerator);
            }
            if (elasticsearchDomainConfig.getSnapshotOptions() != null) {
                jsonGenerator.writeFieldName("SnapshotOptions");
                SnapshotOptionsStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getSnapshotOptions(), jsonGenerator);
            }
            if (elasticsearchDomainConfig.getAdvancedOptions() != null) {
                jsonGenerator.writeFieldName("AdvancedOptions");
                AdvancedOptionsStatusJsonMarshaller.getInstance().marshall(elasticsearchDomainConfig.getAdvancedOptions(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticsearchDomainConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticsearchDomainConfigJsonMarshaller();
        }
        return instance;
    }
}

