/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthInputIncludeEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeTargetHealthRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String targetGroupArn;
    private List<TargetDescription> targets;
    private List<String> include;

    public void setTargetGroupArn(String targetGroupArn) {
        this.targetGroupArn = targetGroupArn;
    }

    public String getTargetGroupArn() {
        return this.targetGroupArn;
    }

    public DescribeTargetHealthRequest withTargetGroupArn(String targetGroupArn) {
        this.setTargetGroupArn(targetGroupArn);
        return this;
    }

    public List<TargetDescription> getTargets() {
        return this.targets;
    }

    public void setTargets(Collection<TargetDescription> targets) {
        if (targets == null) {
            this.targets = null;
            return;
        }
        this.targets = new ArrayList<TargetDescription>(targets);
    }

    public DescribeTargetHealthRequest withTargets(TargetDescription ... targets) {
        if (this.targets == null) {
            this.setTargets(new ArrayList<TargetDescription>(targets.length));
        }
        for (TargetDescription ele : targets) {
            this.targets.add(ele);
        }
        return this;
    }

    public DescribeTargetHealthRequest withTargets(Collection<TargetDescription> targets) {
        this.setTargets(targets);
        return this;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new ArrayList<String>(include);
    }

    public DescribeTargetHealthRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude(new ArrayList<String>(include.length));
        }
        for (String ele : include) {
            this.include.add(ele);
        }
        return this;
    }

    public DescribeTargetHealthRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public DescribeTargetHealthRequest withInclude(DescribeTargetHealthInputIncludeEnum ... include) {
        ArrayList<String> includeCopy = new ArrayList<String>(include.length);
        for (DescribeTargetHealthInputIncludeEnum value : include) {
            includeCopy.add(value.toString());
        }
        if (this.getInclude() == null) {
            this.setInclude(includeCopy);
        } else {
            this.getInclude().addAll(includeCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTargetGroupArn() != null) {
            sb.append("TargetGroupArn: ").append(this.getTargetGroupArn()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTargetHealthRequest)) {
            return false;
        }
        DescribeTargetHealthRequest other = (DescribeTargetHealthRequest)obj;
        if (other.getTargetGroupArn() == null ^ this.getTargetGroupArn() == null) {
            return false;
        }
        if (other.getTargetGroupArn() != null && !other.getTargetGroupArn().equals(this.getTargetGroupArn())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTargetGroupArn() == null ? 0 : this.getTargetGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public DescribeTargetHealthRequest clone() {
        return (DescribeTargetHealthRequest)super.clone();
    }
}

