/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class RemoveListenerCertificatesRequestMarshaller
implements Marshaller<Request<RemoveListenerCertificatesRequest>, RemoveListenerCertificatesRequest> {
    public Request<RemoveListenerCertificatesRequest> marshall(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        if (removeListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeListenerCertificatesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RemoveListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeListenerCertificatesRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString((String)removeListenerCertificatesRequest.getListenerArn()));
        }
        if (removeListenerCertificatesRequest.getCertificates() != null) {
            List<Certificate> certificatesList = removeListenerCertificatesRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue != null) {
                        if (certificatesListValue.getCertificateArn() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.getCertificateArn()));
                        }
                        if (certificatesListValue.getIsDefault() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.getIsDefault()));
                        }
                    }
                    ++certificatesListIndex;
                }
            }
        }
        return request;
    }
}

