/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.ForwardActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.RedirectActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Tag;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupTuple;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

public class CreateListenerRequestMarshaller
implements Marshaller<Request<CreateListenerRequest>, CreateListenerRequest> {
    public Request<CreateListenerRequest> marshall(CreateListenerRequest createListenerRequest) {
        if (createListenerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createListenerRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString((String)createListenerRequest.getLoadBalancerArn()));
        }
        if (createListenerRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createListenerRequest.getProtocol()));
        }
        if (createListenerRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createListenerRequest.getPort()));
        }
        if (createListenerRequest.getSslPolicy() != null) {
            request.addParameter("SslPolicy", StringUtils.fromString((String)createListenerRequest.getSslPolicy()));
        }
        if (createListenerRequest.getCertificates() != null) {
            List<Certificate> certificatesList = createListenerRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue != null) {
                        if (certificatesListValue.getCertificateArn() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString((String)certificatesListValue.getCertificateArn()));
                        }
                        if (certificatesListValue.getIsDefault() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean((Boolean)certificatesListValue.getIsDefault()));
                        }
                    }
                    ++certificatesListIndex;
                }
            }
        }
        if (createListenerRequest.getDefaultActions() != null) {
            List<Action> defaultActionsList = createListenerRequest.getDefaultActions();
            if (defaultActionsList.isEmpty()) {
                request.addParameter("DefaultActions", "");
            } else {
                int defaultActionsListIndex = 1;
                for (Action defaultActionsListValue : defaultActionsList) {
                    if (defaultActionsListValue != null) {
                        ForwardActionConfig forwardConfig;
                        FixedResponseActionConfig fixedResponseConfig;
                        RedirectActionConfig redirectConfig;
                        AuthenticateCognitoActionConfig authenticateCognitoConfig;
                        int authenticationRequestExtraParamsListIndex;
                        Map<String, String> authenticationRequestExtraParams;
                        AuthenticateOidcActionConfig authenticateOidcConfig;
                        if (defaultActionsListValue.getType() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Type", StringUtils.fromString((String)defaultActionsListValue.getType()));
                        }
                        if (defaultActionsListValue.getTargetGroupArn() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)defaultActionsListValue.getTargetGroupArn()));
                        }
                        if ((authenticateOidcConfig = defaultActionsListValue.getAuthenticateOidcConfig()) != null) {
                            if (authenticateOidcConfig.getIssuer() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Issuer", StringUtils.fromString((String)authenticateOidcConfig.getIssuer()));
                            }
                            if (authenticateOidcConfig.getAuthorizationEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getAuthorizationEndpoint()));
                            }
                            if (authenticateOidcConfig.getTokenEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getTokenEndpoint()));
                            }
                            if (authenticateOidcConfig.getUserInfoEndpoint() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getUserInfoEndpoint()));
                            }
                            if (authenticateOidcConfig.getClientId() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientId", StringUtils.fromString((String)authenticateOidcConfig.getClientId()));
                            }
                            if (authenticateOidcConfig.getClientSecret() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringUtils.fromString((String)authenticateOidcConfig.getClientSecret()));
                            }
                            if (authenticateOidcConfig.getSessionCookieName() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringUtils.fromString((String)authenticateOidcConfig.getSessionCookieName()));
                            }
                            if (authenticateOidcConfig.getScope() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.Scope", StringUtils.fromString((String)authenticateOidcConfig.getScope()));
                            }
                            if (authenticateOidcConfig.getSessionTimeout() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateOidcConfig.getSessionTimeout()));
                            }
                            if ((authenticationRequestExtraParams = authenticateOidcConfig.getAuthenticationRequestExtraParams()) != null) {
                                authenticationRequestExtraParamsListIndex = 1;
                                for (Map.Entry entry : authenticationRequestExtraParams.entrySet()) {
                                    if (entry != null && entry.getKey() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)((String)entry.getKey())));
                                    }
                                    if (entry != null && entry.getValue() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)((String)entry.getValue())));
                                    }
                                    ++authenticationRequestExtraParamsListIndex;
                                }
                            }
                            if (authenticateOidcConfig.getOnUnauthenticatedRequest() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateOidcConfig.getOnUnauthenticatedRequest()));
                            }
                            if (authenticateOidcConfig.getUseExistingClientSecret() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateOidcConfig.UseExistingClientSecret", StringUtils.fromBoolean((Boolean)authenticateOidcConfig.getUseExistingClientSecret()));
                            }
                        }
                        if ((authenticateCognitoConfig = defaultActionsListValue.getAuthenticateCognitoConfig()) != null) {
                            if (authenticateCognitoConfig.getUserPoolArn() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolArn()));
                            }
                            if (authenticateCognitoConfig.getUserPoolClientId() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolClientId()));
                            }
                            if (authenticateCognitoConfig.getUserPoolDomain() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolDomain()));
                            }
                            if (authenticateCognitoConfig.getSessionCookieName() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringUtils.fromString((String)authenticateCognitoConfig.getSessionCookieName()));
                            }
                            if (authenticateCognitoConfig.getScope() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.Scope", StringUtils.fromString((String)authenticateCognitoConfig.getScope()));
                            }
                            if (authenticateCognitoConfig.getSessionTimeout() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateCognitoConfig.getSessionTimeout()));
                            }
                            if ((authenticationRequestExtraParams = authenticateCognitoConfig.getAuthenticationRequestExtraParams()) != null) {
                                authenticationRequestExtraParamsListIndex = 1;
                                for (Map.Entry entry : authenticationRequestExtraParams.entrySet()) {
                                    if (entry != null && entry.getKey() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)((String)entry.getKey())));
                                    }
                                    if (entry != null && entry.getValue() != null) {
                                        request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)((String)entry.getValue())));
                                    }
                                    ++authenticationRequestExtraParamsListIndex;
                                }
                            }
                            if (authenticateCognitoConfig.getOnUnauthenticatedRequest() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateCognitoConfig.getOnUnauthenticatedRequest()));
                            }
                        }
                        if (defaultActionsListValue.getOrder() != null) {
                            request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".Order", StringUtils.fromInteger((Integer)defaultActionsListValue.getOrder()));
                        }
                        if ((redirectConfig = defaultActionsListValue.getRedirectConfig()) != null) {
                            if (redirectConfig.getProtocol() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Protocol", StringUtils.fromString((String)redirectConfig.getProtocol()));
                            }
                            if (redirectConfig.getPort() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Port", StringUtils.fromString((String)redirectConfig.getPort()));
                            }
                            if (redirectConfig.getHost() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Host", StringUtils.fromString((String)redirectConfig.getHost()));
                            }
                            if (redirectConfig.getPath() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Path", StringUtils.fromString((String)redirectConfig.getPath()));
                            }
                            if (redirectConfig.getQuery() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.Query", StringUtils.fromString((String)redirectConfig.getQuery()));
                            }
                            if (redirectConfig.getStatusCode() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".RedirectConfig.StatusCode", StringUtils.fromString((String)redirectConfig.getStatusCode()));
                            }
                        }
                        if ((fixedResponseConfig = defaultActionsListValue.getFixedResponseConfig()) != null) {
                            if (fixedResponseConfig.getMessageBody() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.MessageBody", StringUtils.fromString((String)fixedResponseConfig.getMessageBody()));
                            }
                            if (fixedResponseConfig.getStatusCode() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.StatusCode", StringUtils.fromString((String)fixedResponseConfig.getStatusCode()));
                            }
                            if (fixedResponseConfig.getContentType() != null) {
                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".FixedResponseConfig.ContentType", StringUtils.fromString((String)fixedResponseConfig.getContentType()));
                            }
                        }
                        if ((forwardConfig = defaultActionsListValue.getForwardConfig()) != null) {
                            TargetGroupStickinessConfig targetGroupStickinessConfig;
                            if (forwardConfig.getTargetGroups() != null) {
                                List<TargetGroupTuple> targetGroupsList = forwardConfig.getTargetGroups();
                                if (targetGroupsList.isEmpty()) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups", "");
                                } else {
                                    int targetGroupsListIndex = 1;
                                    for (TargetGroupTuple targetGroupTuple : targetGroupsList) {
                                        if (targetGroupTuple != null) {
                                            if (targetGroupTuple.getTargetGroupArn() != null) {
                                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups.member." + targetGroupsListIndex + ".TargetGroupArn", StringUtils.fromString((String)targetGroupTuple.getTargetGroupArn()));
                                            }
                                            if (targetGroupTuple.getWeight() != null) {
                                                request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroups.member." + targetGroupsListIndex + ".Weight", StringUtils.fromInteger((Integer)targetGroupTuple.getWeight()));
                                            }
                                        }
                                        ++targetGroupsListIndex;
                                    }
                                }
                            }
                            if ((targetGroupStickinessConfig = forwardConfig.getTargetGroupStickinessConfig()) != null) {
                                if (targetGroupStickinessConfig.getEnabled() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroupStickinessConfig.Enabled", StringUtils.fromBoolean((Boolean)targetGroupStickinessConfig.getEnabled()));
                                }
                                if (targetGroupStickinessConfig.getDurationSeconds() != null) {
                                    request.addParameter("DefaultActions.member." + defaultActionsListIndex + ".ForwardConfig.TargetGroupStickinessConfig.DurationSeconds", StringUtils.fromInteger((Integer)targetGroupStickinessConfig.getDurationSeconds()));
                                }
                            }
                        }
                    }
                    ++defaultActionsListIndex;
                }
            }
        }
        if (createListenerRequest.getAlpnPolicy() != null) {
            List<String> alpnPolicyList = createListenerRequest.getAlpnPolicy();
            if (alpnPolicyList.isEmpty()) {
                request.addParameter("AlpnPolicy", "");
            } else {
                int alpnPolicyListIndex = 1;
                for (String alpnPolicyListValue : alpnPolicyList) {
                    if (alpnPolicyListValue != null) {
                        request.addParameter("AlpnPolicy.member." + alpnPolicyListIndex, StringUtils.fromString((String)alpnPolicyListValue));
                    }
                    ++alpnPolicyListIndex;
                }
            }
        }
        if (createListenerRequest.getTags() != null) {
            List<Tag> tagsList = createListenerRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        return request;
    }
}

