/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.RedirectActionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

public class ModifyRuleRequestMarshaller
implements Marshaller<Request<ModifyRuleRequest>, ModifyRuleRequest> {
    public Request<ModifyRuleRequest> marshall(ModifyRuleRequest modifyRuleRequest) {
        if (modifyRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyRuleRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyRule");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyRuleRequest.getRuleArn() != null) {
            request.addParameter("RuleArn", StringUtils.fromString((String)modifyRuleRequest.getRuleArn()));
        }
        if (modifyRuleRequest.getConditions() != null) {
            List<RuleCondition> conditionsList = modifyRuleRequest.getConditions();
            if (conditionsList.isEmpty()) {
                request.addParameter("Conditions", "");
            } else {
                int conditionsListIndex = 1;
                for (RuleCondition conditionsListValue : conditionsList) {
                    if (conditionsListValue.getField() != null) {
                        request.addParameter("Conditions.member." + conditionsListIndex + ".Field", StringUtils.fromString((String)conditionsListValue.getField()));
                    }
                    if (conditionsListValue.getValues() != null) {
                        List<String> valuesList = conditionsListValue.getValues();
                        if (valuesList.isEmpty()) {
                            request.addParameter("Conditions.member." + conditionsListIndex + ".Values", "");
                        } else {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Conditions.member." + conditionsListIndex + ".Values.member." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        }
                    }
                    ++conditionsListIndex;
                }
            }
        }
        if (modifyRuleRequest.getActions() != null) {
            List<Action> actionsList = modifyRuleRequest.getActions();
            if (actionsList.isEmpty()) {
                request.addParameter("Actions", "");
            } else {
                int actionsListIndex = 1;
                for (Action actionsListValue : actionsList) {
                    FixedResponseActionConfig fixedResponseConfig;
                    RedirectActionConfig redirectConfig;
                    AuthenticateCognitoActionConfig authenticateCognitoConfig;
                    int authenticationRequestExtraParamsListIndex;
                    Map<String, String> authenticationRequestExtraParams;
                    AuthenticateOidcActionConfig authenticateOidcConfig;
                    if (actionsListValue.getType() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Type", StringUtils.fromString((String)actionsListValue.getType()));
                    }
                    if (actionsListValue.getTargetGroupArn() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".TargetGroupArn", StringUtils.fromString((String)actionsListValue.getTargetGroupArn()));
                    }
                    if ((authenticateOidcConfig = actionsListValue.getAuthenticateOidcConfig()) != null) {
                        if (authenticateOidcConfig.getIssuer() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.Issuer", StringUtils.fromString((String)authenticateOidcConfig.getIssuer()));
                        }
                        if (authenticateOidcConfig.getAuthorizationEndpoint() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthorizationEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getAuthorizationEndpoint()));
                        }
                        if (authenticateOidcConfig.getTokenEndpoint() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.TokenEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getTokenEndpoint()));
                        }
                        if (authenticateOidcConfig.getUserInfoEndpoint() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.UserInfoEndpoint", StringUtils.fromString((String)authenticateOidcConfig.getUserInfoEndpoint()));
                        }
                        if (authenticateOidcConfig.getClientId() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.ClientId", StringUtils.fromString((String)authenticateOidcConfig.getClientId()));
                        }
                        if (authenticateOidcConfig.getClientSecret() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.ClientSecret", StringUtils.fromString((String)authenticateOidcConfig.getClientSecret()));
                        }
                        if (authenticateOidcConfig.getSessionCookieName() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.SessionCookieName", StringUtils.fromString((String)authenticateOidcConfig.getSessionCookieName()));
                        }
                        if (authenticateOidcConfig.getScope() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.Scope", StringUtils.fromString((String)authenticateOidcConfig.getScope()));
                        }
                        if (authenticateOidcConfig.getSessionTimeout() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateOidcConfig.getSessionTimeout()));
                        }
                        if ((authenticationRequestExtraParams = authenticateOidcConfig.getAuthenticationRequestExtraParams()) != null) {
                            authenticationRequestExtraParamsListIndex = 1;
                            for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                                if (entry.getKey() != null) {
                                    request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                }
                                if (entry.getValue() != null) {
                                    request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                }
                                ++authenticationRequestExtraParamsListIndex;
                            }
                        }
                        if (authenticateOidcConfig.getOnUnauthenticatedRequest() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateOidcConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateOidcConfig.getOnUnauthenticatedRequest()));
                        }
                    }
                    if ((authenticateCognitoConfig = actionsListValue.getAuthenticateCognitoConfig()) != null) {
                        if (authenticateCognitoConfig.getUserPoolArn() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolArn", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolArn()));
                        }
                        if (authenticateCognitoConfig.getUserPoolClientId() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolClientId", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolClientId()));
                        }
                        if (authenticateCognitoConfig.getUserPoolDomain() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.UserPoolDomain", StringUtils.fromString((String)authenticateCognitoConfig.getUserPoolDomain()));
                        }
                        if (authenticateCognitoConfig.getSessionCookieName() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.SessionCookieName", StringUtils.fromString((String)authenticateCognitoConfig.getSessionCookieName()));
                        }
                        if (authenticateCognitoConfig.getScope() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.Scope", StringUtils.fromString((String)authenticateCognitoConfig.getScope()));
                        }
                        if (authenticateCognitoConfig.getSessionTimeout() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.SessionTimeout", StringUtils.fromLong((Long)authenticateCognitoConfig.getSessionTimeout()));
                        }
                        if ((authenticationRequestExtraParams = authenticateCognitoConfig.getAuthenticationRequestExtraParams()) != null) {
                            authenticationRequestExtraParamsListIndex = 1;
                            for (Map.Entry<String, String> entry : authenticationRequestExtraParams.entrySet()) {
                                if (entry.getKey() != null) {
                                    request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                                }
                                if (entry.getValue() != null) {
                                    request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.AuthenticationRequestExtraParams.entry." + authenticationRequestExtraParamsListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                                }
                                ++authenticationRequestExtraParamsListIndex;
                            }
                        }
                        if (authenticateCognitoConfig.getOnUnauthenticatedRequest() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".AuthenticateCognitoConfig.OnUnauthenticatedRequest", StringUtils.fromString((String)authenticateCognitoConfig.getOnUnauthenticatedRequest()));
                        }
                    }
                    if (actionsListValue.getOrder() != null) {
                        request.addParameter("Actions.member." + actionsListIndex + ".Order", StringUtils.fromInteger((Integer)actionsListValue.getOrder()));
                    }
                    if ((redirectConfig = actionsListValue.getRedirectConfig()) != null) {
                        if (redirectConfig.getProtocol() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Protocol", StringUtils.fromString((String)redirectConfig.getProtocol()));
                        }
                        if (redirectConfig.getPort() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Port", StringUtils.fromString((String)redirectConfig.getPort()));
                        }
                        if (redirectConfig.getHost() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Host", StringUtils.fromString((String)redirectConfig.getHost()));
                        }
                        if (redirectConfig.getPath() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Path", StringUtils.fromString((String)redirectConfig.getPath()));
                        }
                        if (redirectConfig.getQuery() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.Query", StringUtils.fromString((String)redirectConfig.getQuery()));
                        }
                        if (redirectConfig.getStatusCode() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".RedirectConfig.StatusCode", StringUtils.fromString((String)redirectConfig.getStatusCode()));
                        }
                    }
                    if ((fixedResponseConfig = actionsListValue.getFixedResponseConfig()) != null) {
                        if (fixedResponseConfig.getMessageBody() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.MessageBody", StringUtils.fromString((String)fixedResponseConfig.getMessageBody()));
                        }
                        if (fixedResponseConfig.getStatusCode() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.StatusCode", StringUtils.fromString((String)fixedResponseConfig.getStatusCode()));
                        }
                        if (fixedResponseConfig.getContentType() != null) {
                            request.addParameter("Actions.member." + actionsListIndex + ".FixedResponseConfig.ContentType", StringUtils.fromString((String)fixedResponseConfig.getContentType()));
                        }
                    }
                    ++actionsListIndex;
                }
            }
        }
        return request;
    }
}

