/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.ValidationMessage;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class ValidationMessageStaxUnmarshaller
implements Unmarshaller<ValidationMessage, StaxUnmarshallerContext> {
    private static ValidationMessageStaxUnmarshaller instance;

    public ValidationMessage unmarshall(StaxUnmarshallerContext context) throws Exception {
        ValidationMessage validationMessage = new ValidationMessage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return validationMessage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Message", targetDepth)) {
                    validationMessage.setMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Severity", targetDepth)) {
                    validationMessage.setSeverity(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Namespace", targetDepth)) {
                    validationMessage.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OptionName", targetDepth)) continue;
                validationMessage.setOptionName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return validationMessage;
    }

    public static ValidationMessageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ValidationMessageStaxUnmarshaller();
        }
        return instance;
    }
}

