/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateEnvironmentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String environmentName;
    private String groupName;
    private String description;
    private String cNAMEPrefix;
    private EnvironmentTier tier;
    private SdkInternalList<Tag> tags;
    private String versionLabel;
    private String templateName;
    private String solutionStackName;
    private SdkInternalList<ConfigurationOptionSetting> optionSettings;
    private SdkInternalList<OptionSpecification> optionsToRemove;

    public CreateEnvironmentRequest() {
    }

    public CreateEnvironmentRequest(String applicationName, String environmentName) {
        this.setApplicationName(applicationName);
        this.setEnvironmentName(environmentName);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public CreateEnvironmentRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public CreateEnvironmentRequest withEnvironmentName(String environmentName) {
        this.setEnvironmentName(environmentName);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CreateEnvironmentRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateEnvironmentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCNAMEPrefix(String cNAMEPrefix) {
        this.cNAMEPrefix = cNAMEPrefix;
    }

    public String getCNAMEPrefix() {
        return this.cNAMEPrefix;
    }

    public CreateEnvironmentRequest withCNAMEPrefix(String cNAMEPrefix) {
        this.setCNAMEPrefix(cNAMEPrefix);
        return this;
    }

    public void setTier(EnvironmentTier tier) {
        this.tier = tier;
    }

    public EnvironmentTier getTier() {
        return this.tier;
    }

    public CreateEnvironmentRequest withTier(EnvironmentTier tier) {
        this.setTier(tier);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateEnvironmentRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateEnvironmentRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public CreateEnvironmentRequest withVersionLabel(String versionLabel) {
        this.setVersionLabel(versionLabel);
        return this;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public CreateEnvironmentRequest withTemplateName(String templateName) {
        this.setTemplateName(templateName);
        return this;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public CreateEnvironmentRequest withSolutionStackName(String solutionStackName) {
        this.setSolutionStackName(solutionStackName);
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new SdkInternalList();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        this.optionSettings = new SdkInternalList(optionSettings);
    }

    public CreateEnvironmentRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.optionSettings == null) {
            this.setOptionSettings((Collection<ConfigurationOptionSetting>)new SdkInternalList(optionSettings.length));
        }
        for (ConfigurationOptionSetting ele : optionSettings) {
            this.optionSettings.add((Object)ele);
        }
        return this;
    }

    public CreateEnvironmentRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        this.setOptionSettings(optionSettings);
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new SdkInternalList();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
            return;
        }
        this.optionsToRemove = new SdkInternalList(optionsToRemove);
    }

    public CreateEnvironmentRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.optionsToRemove == null) {
            this.setOptionsToRemove((Collection<OptionSpecification>)new SdkInternalList(optionsToRemove.length));
        }
        for (OptionSpecification ele : optionsToRemove) {
            this.optionsToRemove.add((Object)ele);
        }
        return this;
    }

    public CreateEnvironmentRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        this.setOptionsToRemove(optionsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: ").append(this.getApplicationName()).append(",");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: ").append(this.getEnvironmentName()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCNAMEPrefix() != null) {
            sb.append("CNAMEPrefix: ").append(this.getCNAMEPrefix()).append(",");
        }
        if (this.getTier() != null) {
            sb.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getVersionLabel() != null) {
            sb.append("VersionLabel: ").append(this.getVersionLabel()).append(",");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: ").append(this.getTemplateName()).append(",");
        }
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: ").append(this.getSolutionStackName()).append(",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: ").append(this.getOptionSettings()).append(",");
        }
        if (this.getOptionsToRemove() != null) {
            sb.append("OptionsToRemove: ").append(this.getOptionsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCNAMEPrefix() == null ^ this.getCNAMEPrefix() == null) {
            return false;
        }
        if (other.getCNAMEPrefix() != null && !other.getCNAMEPrefix().equals(this.getCNAMEPrefix())) {
            return false;
        }
        if (other.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (other.getTier() != null && !other.getTier().equals(this.getTier())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getVersionLabel() == null ^ this.getVersionLabel() == null) {
            return false;
        }
        if (other.getVersionLabel() != null && !other.getVersionLabel().equals(this.getVersionLabel())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        if (other.getOptionSettings() != null && !other.getOptionSettings().equals(this.getOptionSettings())) {
            return false;
        }
        if (other.getOptionsToRemove() == null ^ this.getOptionsToRemove() == null) {
            return false;
        }
        return other.getOptionsToRemove() == null || other.getOptionsToRemove().equals(this.getOptionsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCNAMEPrefix() == null ? 0 : this.getCNAMEPrefix().hashCode());
        hashCode = 31 * hashCode + (this.getTier() == null ? 0 : this.getTier().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabel() == null ? 0 : this.getVersionLabel().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : this.getOptionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToRemove() == null ? 0 : this.getOptionsToRemove().hashCode());
        return hashCode;
    }

    public CreateEnvironmentRequest clone() {
        return (CreateEnvironmentRequest)super.clone();
    }
}

