/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreatePlatformVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreatePlatformVersionRequestMarshaller
implements Marshaller<Request<CreatePlatformVersionRequest>, CreatePlatformVersionRequest> {
    public Request<CreatePlatformVersionRequest> marshall(CreatePlatformVersionRequest createPlatformVersionRequest) {
        SdkInternalList optionSettingsList;
        S3Location platformDefinitionBundle;
        if (createPlatformVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformVersionRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreatePlatformVersion");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPlatformVersionRequest.getPlatformName() != null) {
            request.addParameter("PlatformName", StringUtils.fromString((String)createPlatformVersionRequest.getPlatformName()));
        }
        if (createPlatformVersionRequest.getPlatformVersion() != null) {
            request.addParameter("PlatformVersion", StringUtils.fromString((String)createPlatformVersionRequest.getPlatformVersion()));
        }
        if ((platformDefinitionBundle = createPlatformVersionRequest.getPlatformDefinitionBundle()) != null) {
            if (platformDefinitionBundle.getS3Bucket() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Bucket", StringUtils.fromString((String)platformDefinitionBundle.getS3Bucket()));
            }
            if (platformDefinitionBundle.getS3Key() != null) {
                request.addParameter("PlatformDefinitionBundle.S3Key", StringUtils.fromString((String)platformDefinitionBundle.getS3Key()));
            }
        }
        if (createPlatformVersionRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)createPlatformVersionRequest.getEnvironmentName()));
        }
        if (!(optionSettingsList = (SdkInternalList)createPlatformVersionRequest.getOptionSettings()).isEmpty() || !optionSettingsList.isAutoConstruct()) {
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

