/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TerminateEnvironmentRequestMarshaller
implements Marshaller<Request<TerminateEnvironmentRequest>, TerminateEnvironmentRequest> {
    public Request<TerminateEnvironmentRequest> marshall(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        if (terminateEnvironmentRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateEnvironmentRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "TerminateEnvironment");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (terminateEnvironmentRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString((String)terminateEnvironmentRequest.getEnvironmentId()));
        }
        if (terminateEnvironmentRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)terminateEnvironmentRequest.getEnvironmentName()));
        }
        if (terminateEnvironmentRequest.getTerminateResources() != null) {
            request.addParameter("TerminateResources", StringUtils.fromBoolean((Boolean)terminateEnvironmentRequest.getTerminateResources()));
        }
        if (terminateEnvironmentRequest.getForceTerminate() != null) {
            request.addParameter("ForceTerminate", StringUtils.fromBoolean((Boolean)terminateEnvironmentRequest.getForceTerminate()));
        }
        return request;
    }
}

