/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SwapEnvironmentCNAMEsRequestMarshaller
implements Marshaller<Request<SwapEnvironmentCNAMEsRequest>, SwapEnvironmentCNAMEsRequest> {
    public Request<SwapEnvironmentCNAMEsRequest> marshall(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) {
        if (swapEnvironmentCNAMEsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)swapEnvironmentCNAMEsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "SwapEnvironmentCNAMEs");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (swapEnvironmentCNAMEsRequest.getSourceEnvironmentId() != null) {
            request.addParameter("SourceEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.getSourceEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.getSourceEnvironmentName() != null) {
            request.addParameter("SourceEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.getSourceEnvironmentName()));
        }
        if (swapEnvironmentCNAMEsRequest.getDestinationEnvironmentId() != null) {
            request.addParameter("DestinationEnvironmentId", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.getDestinationEnvironmentId()));
        }
        if (swapEnvironmentCNAMEsRequest.getDestinationEnvironmentName() != null) {
            request.addParameter("DestinationEnvironmentName", StringUtils.fromString((String)swapEnvironmentCNAMEsRequest.getDestinationEnvironmentName()));
        }
        return request;
    }
}

