/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticache.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateServerlessCacheSnapshot"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateServerlessCacheSnapshotResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Redis
     * only.
     * </p>
     */
    private ServerlessCacheSnapshot serverlessCacheSnapshot;

    /**
     * <p>
     * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Redis
     * only.
     * </p>
     * 
     * @param serverlessCacheSnapshot
     *        The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
     *        Redis only.
     */

    public void setServerlessCacheSnapshot(ServerlessCacheSnapshot serverlessCacheSnapshot) {
        this.serverlessCacheSnapshot = serverlessCacheSnapshot;
    }

    /**
     * <p>
     * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Redis
     * only.
     * </p>
     * 
     * @return The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
     *         Redis only.
     */

    public ServerlessCacheSnapshot getServerlessCacheSnapshot() {
        return this.serverlessCacheSnapshot;
    }

    /**
     * <p>
     * The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Redis
     * only.
     * </p>
     * 
     * @param serverlessCacheSnapshot
     *        The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for
     *        Redis only.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateServerlessCacheSnapshotResult withServerlessCacheSnapshot(ServerlessCacheSnapshot serverlessCacheSnapshot) {
        setServerlessCacheSnapshot(serverlessCacheSnapshot);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getServerlessCacheSnapshot() != null)
            sb.append("ServerlessCacheSnapshot: ").append(getServerlessCacheSnapshot());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateServerlessCacheSnapshotResult == false)
            return false;
        CreateServerlessCacheSnapshotResult other = (CreateServerlessCacheSnapshotResult) obj;
        if (other.getServerlessCacheSnapshot() == null ^ this.getServerlessCacheSnapshot() == null)
            return false;
        if (other.getServerlessCacheSnapshot() != null && other.getServerlessCacheSnapshot().equals(this.getServerlessCacheSnapshot()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getServerlessCacheSnapshot() == null) ? 0 : getServerlessCacheSnapshot().hashCode());
        return hashCode;
    }

    @Override
    public CreateServerlessCacheSnapshotResult clone() {
        try {
            return (CreateServerlessCacheSnapshotResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
