/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.DescribeUpdateActionsRequest;
import com.amazonaws.services.elasticache.model.TimeRangeFilter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class DescribeUpdateActionsRequestMarshaller
implements Marshaller<Request<DescribeUpdateActionsRequest>, DescribeUpdateActionsRequest> {
    public Request<DescribeUpdateActionsRequest> marshall(DescribeUpdateActionsRequest describeUpdateActionsRequest) {
        TimeRangeFilter serviceUpdateTimeRange;
        if (describeUpdateActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeUpdateActionsRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeUpdateActions");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeUpdateActionsRequest.getServiceUpdateName() != null) {
            request.addParameter("ServiceUpdateName", StringUtils.fromString((String)describeUpdateActionsRequest.getServiceUpdateName()));
        }
        if (!describeUpdateActionsRequest.getReplicationGroupIds().isEmpty() || !((SdkInternalList)describeUpdateActionsRequest.getReplicationGroupIds()).isAutoConstruct()) {
            SdkInternalList replicationGroupIdsList = (SdkInternalList)describeUpdateActionsRequest.getReplicationGroupIds();
            int replicationGroupIdsListIndex = 1;
            for (String replicationGroupIdsListValue : replicationGroupIdsList) {
                if (replicationGroupIdsListValue != null) {
                    request.addParameter("ReplicationGroupIds.member." + replicationGroupIdsListIndex, StringUtils.fromString((String)replicationGroupIdsListValue));
                }
                ++replicationGroupIdsListIndex;
            }
        }
        if (!describeUpdateActionsRequest.getCacheClusterIds().isEmpty() || !((SdkInternalList)describeUpdateActionsRequest.getCacheClusterIds()).isAutoConstruct()) {
            SdkInternalList cacheClusterIdsList = (SdkInternalList)describeUpdateActionsRequest.getCacheClusterIds();
            int cacheClusterIdsListIndex = 1;
            for (String cacheClusterIdsListValue : cacheClusterIdsList) {
                if (cacheClusterIdsListValue != null) {
                    request.addParameter("CacheClusterIds.member." + cacheClusterIdsListIndex, StringUtils.fromString((String)cacheClusterIdsListValue));
                }
                ++cacheClusterIdsListIndex;
            }
        }
        if (describeUpdateActionsRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeUpdateActionsRequest.getEngine()));
        }
        if (!describeUpdateActionsRequest.getServiceUpdateStatus().isEmpty() || !((SdkInternalList)describeUpdateActionsRequest.getServiceUpdateStatus()).isAutoConstruct()) {
            SdkInternalList serviceUpdateStatusList = (SdkInternalList)describeUpdateActionsRequest.getServiceUpdateStatus();
            int serviceUpdateStatusListIndex = 1;
            for (String serviceUpdateStatusListValue : serviceUpdateStatusList) {
                if (serviceUpdateStatusListValue != null) {
                    request.addParameter("ServiceUpdateStatus.member." + serviceUpdateStatusListIndex, StringUtils.fromString((String)serviceUpdateStatusListValue));
                }
                ++serviceUpdateStatusListIndex;
            }
        }
        if ((serviceUpdateTimeRange = describeUpdateActionsRequest.getServiceUpdateTimeRange()) != null) {
            if (serviceUpdateTimeRange.getStartTime() != null) {
                request.addParameter("ServiceUpdateTimeRange.StartTime", StringUtils.fromDate((Date)serviceUpdateTimeRange.getStartTime()));
            }
            if (serviceUpdateTimeRange.getEndTime() != null) {
                request.addParameter("ServiceUpdateTimeRange.EndTime", StringUtils.fromDate((Date)serviceUpdateTimeRange.getEndTime()));
            }
        }
        if (!describeUpdateActionsRequest.getUpdateActionStatus().isEmpty() || !((SdkInternalList)describeUpdateActionsRequest.getUpdateActionStatus()).isAutoConstruct()) {
            SdkInternalList updateActionStatusList = (SdkInternalList)describeUpdateActionsRequest.getUpdateActionStatus();
            int updateActionStatusListIndex = 1;
            for (String updateActionStatusListValue : updateActionStatusList) {
                if (updateActionStatusListValue != null) {
                    request.addParameter("UpdateActionStatus.member." + updateActionStatusListIndex, StringUtils.fromString((String)updateActionStatusListValue));
                }
                ++updateActionStatusListIndex;
            }
        }
        if (describeUpdateActionsRequest.getShowNodeLevelUpdateStatus() != null) {
            request.addParameter("ShowNodeLevelUpdateStatus", StringUtils.fromBoolean((Boolean)describeUpdateActionsRequest.getShowNodeLevelUpdateStatus()));
        }
        if (describeUpdateActionsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeUpdateActionsRequest.getMaxRecords()));
        }
        if (describeUpdateActionsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeUpdateActionsRequest.getMarker()));
        }
        return request;
    }
}

