/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eksauth;

import javax.annotation.Generated;

import com.amazonaws.services.eksauth.model.*;

/**
 * Interface for accessing Amazon EKS Auth asynchronously. Each asynchronous method will return a Java Future object
 * representing the asynchronous operation; overloads which accept an {@code AsyncHandler} can be used to receive
 * notification when an asynchronous operation completes.
 * <p>
 * <b>Note:</b> Do not directly implement this interface, new methods are added to it regularly. Extend from
 * {@link com.amazonaws.services.eksauth.AbstractAmazonEKSAuthAsync} instead.
 * </p>
 * <p>
 * <p>
 * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod Identity
 * Agent.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public interface AmazonEKSAuthAsync extends AmazonEKSAuth {

    /**
     * <p>
     * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod
     * Identity Agent.
     * </p>
     * <p>
     * We recommend that applications use the Amazon Web Services SDKs to connect to Amazon Web Services services; if
     * credentials from an EKS Pod Identity association are available in the pod, the latest versions of the SDKs use
     * them automatically.
     * </p>
     * 
     * @param assumeRoleForPodIdentityRequest
     * @return A Java Future containing the result of the AssumeRoleForPodIdentity operation returned by the service.
     * @sample AmazonEKSAuthAsync.AssumeRoleForPodIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssumeRoleForPodIdentityResult> assumeRoleForPodIdentityAsync(AssumeRoleForPodIdentityRequest assumeRoleForPodIdentityRequest);

    /**
     * <p>
     * The Amazon EKS Auth API and the <code>AssumeRoleForPodIdentity</code> action are only used by the EKS Pod
     * Identity Agent.
     * </p>
     * <p>
     * We recommend that applications use the Amazon Web Services SDKs to connect to Amazon Web Services services; if
     * credentials from an EKS Pod Identity association are available in the pod, the latest versions of the SDKs use
     * them automatically.
     * </p>
     * 
     * @param assumeRoleForPodIdentityRequest
     * @param asyncHandler
     *        Asynchronous callback handler for events in the lifecycle of the request. Users can provide an
     *        implementation of the callback methods in this interface to receive notification of successful or
     *        unsuccessful completion of the operation.
     * @return A Java Future containing the result of the AssumeRoleForPodIdentity operation returned by the service.
     * @sample AmazonEKSAuthAsyncHandler.AssumeRoleForPodIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    java.util.concurrent.Future<AssumeRoleForPodIdentityResult> assumeRoleForPodIdentityAsync(AssumeRoleForPodIdentityRequest assumeRoleForPodIdentityRequest,
            com.amazonaws.handlers.AsyncHandler<AssumeRoleForPodIdentityRequest, AssumeRoleForPodIdentityResult> asyncHandler);

}
