/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.ClusterIssue;
import com.amazonaws.services.eks.model.transform.ClusterHealthMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterHealth
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ClusterIssue> issues;

    public List<ClusterIssue> getIssues() {
        return this.issues;
    }

    public void setIssues(Collection<ClusterIssue> issues) {
        if (issues == null) {
            this.issues = null;
            return;
        }
        this.issues = new ArrayList<ClusterIssue>(issues);
    }

    public ClusterHealth withIssues(ClusterIssue ... issues) {
        if (this.issues == null) {
            this.setIssues(new ArrayList<ClusterIssue>(issues.length));
        }
        for (ClusterIssue ele : issues) {
            this.issues.add(ele);
        }
        return this;
    }

    public ClusterHealth withIssues(Collection<ClusterIssue> issues) {
        this.setIssues(issues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIssues() != null) {
            sb.append("Issues: ").append(this.getIssues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterHealth)) {
            return false;
        }
        ClusterHealth other = (ClusterHealth)obj;
        if (other.getIssues() == null ^ this.getIssues() == null) {
            return false;
        }
        return other.getIssues() == null || other.getIssues().equals(this.getIssues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIssues() == null ? 0 : this.getIssues().hashCode());
        return hashCode;
    }

    public ClusterHealth clone() {
        try {
            return (ClusterHealth)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterHealthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

