/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.AutoScalingGroup;
import com.amazonaws.services.eks.model.transform.NodegroupResourcesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodegroupResources
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AutoScalingGroup> autoScalingGroups;
    private String remoteAccessSecurityGroup;

    public List<AutoScalingGroup> getAutoScalingGroups() {
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        this.autoScalingGroups = new ArrayList<AutoScalingGroup>(autoScalingGroups);
    }

    public NodegroupResources withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.autoScalingGroups == null) {
            this.setAutoScalingGroups(new ArrayList<AutoScalingGroup>(autoScalingGroups.length));
        }
        for (AutoScalingGroup ele : autoScalingGroups) {
            this.autoScalingGroups.add(ele);
        }
        return this;
    }

    public NodegroupResources withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        this.setAutoScalingGroups(autoScalingGroups);
        return this;
    }

    public void setRemoteAccessSecurityGroup(String remoteAccessSecurityGroup) {
        this.remoteAccessSecurityGroup = remoteAccessSecurityGroup;
    }

    public String getRemoteAccessSecurityGroup() {
        return this.remoteAccessSecurityGroup;
    }

    public NodegroupResources withRemoteAccessSecurityGroup(String remoteAccessSecurityGroup) {
        this.setRemoteAccessSecurityGroup(remoteAccessSecurityGroup);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.getAutoScalingGroups()).append(",");
        }
        if (this.getRemoteAccessSecurityGroup() != null) {
            sb.append("RemoteAccessSecurityGroup: ").append(this.getRemoteAccessSecurityGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupResources)) {
            return false;
        }
        NodegroupResources other = (NodegroupResources)obj;
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getRemoteAccessSecurityGroup() == null ^ this.getRemoteAccessSecurityGroup() == null) {
            return false;
        }
        return other.getRemoteAccessSecurityGroup() == null || other.getRemoteAccessSecurityGroup().equals(this.getRemoteAccessSecurityGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getRemoteAccessSecurityGroup() == null ? 0 : this.getRemoteAccessSecurityGroup().hashCode());
        return hashCode;
    }

    public NodegroupResources clone() {
        try {
            return (NodegroupResources)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NodegroupResourcesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

