/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.eks.AmazonEKS;
import com.amazonaws.services.eks.model.DescribeAddonRequest;
import com.amazonaws.services.eks.model.DescribeClusterRequest;
import com.amazonaws.services.eks.model.DescribeNodegroupRequest;
import com.amazonaws.services.eks.waiters.AddonActive;
import com.amazonaws.services.eks.waiters.AddonDeleted;
import com.amazonaws.services.eks.waiters.ClusterActive;
import com.amazonaws.services.eks.waiters.ClusterDeleted;
import com.amazonaws.services.eks.waiters.DescribeAddonFunction;
import com.amazonaws.services.eks.waiters.DescribeClusterFunction;
import com.amazonaws.services.eks.waiters.DescribeNodegroupFunction;
import com.amazonaws.services.eks.waiters.NodegroupActive;
import com.amazonaws.services.eks.waiters.NodegroupDeleted;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonEKSWaiters {
    private final AmazonEKS client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonEKSWaiters");

    @SdkInternalApi
    public AmazonEKSWaiters(AmazonEKS client) {
        this.client = client;
    }

    public Waiter<DescribeClusterRequest> clusterDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterDeleted.IsACTIVEMatcher(), new ClusterDeleted.IsCREATINGMatcher(), new ClusterDeleted.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterRequest> clusterActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeClusterFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ClusterActive.IsDELETINGMatcher(), new ClusterActive.IsFAILEDMatcher(), new ClusterActive.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNodegroupRequest> nodegroupDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNodegroupFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NodegroupDeleted.IsDELETE_FAILEDMatcher(), new NodegroupDeleted.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNodegroupRequest> nodegroupActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeNodegroupFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new NodegroupActive.IsCREATE_FAILEDMatcher(), new NodegroupActive.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(80), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAddonRequest> addonActive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAddonFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AddonActive.IsCREATE_FAILEDMatcher(), new AddonActive.IsDEGRADEDMatcher(), new AddonActive.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAddonRequest> addonDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeAddonFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new AddonDeleted.IsDELETE_FAILEDMatcher(), new AddonDeleted.IsResourceNotFoundExceptionMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(10))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

