/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class FileSystemDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").build();
    private static final MarshallingInfo<String> CREATIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationToken").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<String> FILESYSTEMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemArn").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Integer> NUMBEROFMOUNTTARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfMountTargets").build();
    private static final MarshallingInfo<StructuredPojo> SIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeInBytes").build();
    private static final MarshallingInfo<String> PERFORMANCEMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PerformanceMode").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").build();
    private static final MarshallingInfo<String> KMSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KmsKeyId").build();
    private static final MarshallingInfo<String> THROUGHPUTMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThroughputMode").build();
    private static final MarshallingInfo<Double> PROVISIONEDTHROUGHPUTINMIBPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughputInMibps").build();
    private static final MarshallingInfo<String> AVAILABILITYZONENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZoneName").build();
    private static final MarshallingInfo<String> AVAILABILITYZONEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZoneId").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<StructuredPojo> FILESYSTEMPROTECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemProtection").build();
    private static final FileSystemDescriptionMarshaller instance = new FileSystemDescriptionMarshaller();

    public static FileSystemDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileSystemDescription fileSystemDescription, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)fileSystemDescription.getOwnerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getCreationToken(), CREATIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getFileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getFileSystemArn(), FILESYSTEMARN_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getLifeCycleState(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getNumberOfMountTargets(), NUMBEROFMOUNTTARGETS_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getSizeInBytes(), SIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getPerformanceMode(), PERFORMANCEMODE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getEncrypted(), ENCRYPTED_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getKmsKeyId(), KMSKEYID_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getThroughputMode(), THROUGHPUTMODE_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getProvisionedThroughputInMibps(), PROVISIONEDTHROUGHPUTINMIBPS_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getAvailabilityZoneName(), AVAILABILITYZONENAME_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getAvailabilityZoneId(), AVAILABILITYZONEID_BINDING);
            protocolMarshaller.marshall(fileSystemDescription.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)fileSystemDescription.getFileSystemProtection(), FILESYSTEMPROTECTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

