/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.PosixUser;
import com.amazonaws.services.elasticfilesystem.model.RootDirectory;
import com.amazonaws.services.elasticfilesystem.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateAccessPointRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private SdkInternalList<Tag> tags;
    private String fileSystemId;
    private PosixUser posixUser;
    private RootDirectory rootDirectory;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateAccessPointRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateAccessPointRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateAccessPointRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public CreateAccessPointRequest withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public void setPosixUser(PosixUser posixUser) {
        this.posixUser = posixUser;
    }

    public PosixUser getPosixUser() {
        return this.posixUser;
    }

    public CreateAccessPointRequest withPosixUser(PosixUser posixUser) {
        this.setPosixUser(posixUser);
        return this;
    }

    public void setRootDirectory(RootDirectory rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public RootDirectory getRootDirectory() {
        return this.rootDirectory;
    }

    public CreateAccessPointRequest withRootDirectory(RootDirectory rootDirectory) {
        this.setRootDirectory(rootDirectory);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getPosixUser() != null) {
            sb.append("PosixUser: ").append(this.getPosixUser()).append(",");
        }
        if (this.getRootDirectory() != null) {
            sb.append("RootDirectory: ").append(this.getRootDirectory());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointRequest)) {
            return false;
        }
        CreateAccessPointRequest other = (CreateAccessPointRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getPosixUser() == null ^ this.getPosixUser() == null) {
            return false;
        }
        if (other.getPosixUser() != null && !other.getPosixUser().equals(this.getPosixUser())) {
            return false;
        }
        if (other.getRootDirectory() == null ^ this.getRootDirectory() == null) {
            return false;
        }
        return other.getRootDirectory() == null || other.getRootDirectory().equals(this.getRootDirectory());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getPosixUser() == null ? 0 : this.getPosixUser().hashCode());
        hashCode = 31 * hashCode + (this.getRootDirectory() == null ? 0 : this.getRootDirectory().hashCode());
        return hashCode;
    }

    public CreateAccessPointRequest clone() {
        return (CreateAccessPointRequest)super.clone();
    }
}

